import React from "react";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import DownloadSelectionMoldNotifier from "../notifiers/DownloadSelectionMoldNotifier";
import DownloadSelectionMoldRequester from "../requesters/DownloadSelectionMoldRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';

export default class DownloadSelectionMold extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new DownloadSelectionMoldNotifier(this);
		this.requester = new DownloadSelectionMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className={className}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1236172592" mode="normal">
				</UiText>
			</div>
		);
	}
}

DisplayFactory.register("DownloadSelectionMold", DownloadSelectionMold);