import React from "react";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import UiTextEditableCode from "alexandria-ui-elements/src/displays/components/TextEditableCode";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractTextExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a703826529" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a898955915" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a926332811" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1532518128" format="filled" layout="vertical" spacing="8">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1900505514" format="body1 widgetDemo" mode="normal">
							</UiText>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1006319667" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1194236294" mode="normal" language="Html" value="Text(value=&quot;lorem ipsum&quot;) text1">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a265791636" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a98066438" format="h6" mode="normal" value="No facets with label">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_600994068" format="filled" layout="vertical" spacing="8">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1703992010" label="título del campo" format="body1 widgetDemo" mode="normal">
							</UiText>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_883910335" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1698871398" mode="normal" language="Html" value="Text text2 as Labeled(&quot;t&iacute;tulo del campo&quot;)&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;value=&quot;lorem ipsum&quot;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_850420659" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1757535718" format="h6" mode="normal" value="Editable facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_387272473" format="filled" layout="vertical" spacing="8">
							<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_299975957" label="campo editable" format="body1 widgetDemo" mode="normal" placeholder="">
							</UiTextEditable>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1263617462" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1798057787" mode="normal" language="Html" value="Text(value=&quot;lorem ipsum&quot;) text3 as Editable Labeled(&quot;campo editable&quot;)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a267605518" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_479938970" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1689189676" format="h6" mode="normal" value="Code facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a533002209" format="filled" layout="vertical" spacing="8">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_896037220" format="body1 widgetDemo" mode="normal" language="Html" value="Text(value=&quot;lorem&quot;) text1">
							</UiTextCode>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1110503284" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1095917328" mode="normal" language="Html" value="Text textCode1 as Code(language=Html)&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;value&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;=========&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;lorem&quot;) text1&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;=========&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1155175599" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1327075837" format="h6" mode="normal" value="Code and Editable facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1397085480" format="filled" layout="vertical" spacing="8">
							<UiTextEditableCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1320348455" format="body1 widgetDemo" mode="normal" language="Html" value="&lt;div&gt;Here goes code&lt;/div&gt;">
							</UiTextEditableCode>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1903293195" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1500790611" mode="normal" language="Html" value="Text textCode1 as Code(language=Html) Editable&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;value&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;=========&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;lt;div&amp;gt;Here goes code&amp;lt;/div&amp;gt;&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;=========&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}