import React from "react";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTable from "alexandria-ui-elements/src/displays/components/Table";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiHeading from "alexandria-ui-elements/src/displays/components/Heading";
import UiSelectPreviousItem from "alexandria-ui-elements/src/displays/components/SelectPreviousItem";
import UiSelectNextItem from "alexandria-ui-elements/src/displays/components/SelectNextItem";
import DisplaysTable1Row from "ui-elements/gen/displays/rows/Table1Row";
import DisplaysTable11Mold from "ui-elements/gen/displays/items/Table11Mold";
import DisplaysTable12Mold from "ui-elements/gen/displays/items/Table12Mold";
import DisplaysTable2Row from "ui-elements/gen/displays/rows/Table2Row";
import DisplaysTable21Mold from "ui-elements/gen/displays/items/Table21Mold";
import DisplaysTable22Mold from "ui-elements/gen/displays/items/Table22Mold";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractTableExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a396088592" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1867994564" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_574218940" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_127177748" format="filledNoAir" layout="vertical" spacing="8">
							<UiTable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_97726499" pageSize={20} itemHeight={60} scrollingMark={true}>
							</UiTable>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1748586045" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1628038146" mode="normal" language="Html" value="Table(itemClass=&quot;io.intino.alexandria.ui.documentation.Person&quot;) table&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold &gt; Item(height=60px,width=30%) table1Mold &gt; Text firstName as Editable&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold &gt; Item(height=60px,width=70%) table2Mold &gt; Text lastName as Editable">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a477003694" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2049700362" format="h6" mode="normal" value="No facets with heading">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1257368310" format="filledNoAir" layout="vertical" spacing="8">
							<UiTable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_969199731" pageSize={20} itemHeight={60} scrollingMark={true} selection="single">
								<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1505620314" style={{width:"30%",paddingRight:"10px",paddingLeft:"10px"}}>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_981107278" mode="normal" value="first name">
									</UiText>
								</UiHeading>
								<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a39336710" style={{width:"70%",paddingRight:"10px"}}>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1695006197" mode="normal" value="last name">
									</UiText>
								</UiHeading>
							</UiTable>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_333083552" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_416765745" mode="normal" language="Html" value="Table(itemClass=&quot;io.intino.alexandria.ui.documentation.Person&quot;) table&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Heading firstNameHeading &gt; Text(value=&quot;first name&quot;)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Item(height=60px,width=30%) table21Mold &gt; Text firstName&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Heading lastNameHeading &gt; Text(value=&quot;last name&quot;)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Item(height=60px,width=70%) table22Mold &gt; Text lastName">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1846951968" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a103430283" format="h6" mode="normal" value="Selectable collection buttons">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a505205155" format="filledNoAir" layout="horizontal centercenter flexible" spacing="8">
							<UiSelectPreviousItem context={this._context.bind(this)} owner={this._owner.bind(this)} id="a90094062" title="Previous" target="self" mode="MaterialIconButton" icon="KeyboardArrowLeft" size="Medium" format="airRight">
							</UiSelectPreviousItem>
							<UiSelectNextItem context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1892326762" title="Next" target="self" mode="MaterialIconButton" icon="KeyboardArrowRight" size="Medium">
							</UiSelectNextItem>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1099055277" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_130070998" mode="normal" language="Html" value="Table(itemClass=&quot;io.intino.alexandria.ui.documentation.Person&quot;) table&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Heading firstNameHeading &gt; Text(value=&quot;first name&quot;)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Item(height=60px,width=30%) table21Mold &gt; Text firstName&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Heading lastNameHeading &gt; Text(value=&quot;last name&quot;)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Item(height=60px,width=70%) table22Mold &gt; Text lastName">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}