import React from "react";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiSorting from "alexandria-ui-elements/src/displays/components/Sorting";
import UiList from "alexandria-ui-elements/src/displays/components/List";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiSelectorComboBox from "alexandria-ui-elements/src/displays/components/SelectorComboBox";
import DisplaysSorting1Mold from "ui-elements/gen/displays/items/Sorting1Mold";
import DisplaysSorting2Mold from "ui-elements/gen/displays/items/Sorting2Mold";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractSortingExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2080752234" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_968417070" layout="vertical" width="49.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a159340649" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1665958127" format="filledNoAir" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1705186667" format="air" layout="horizontal">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1286227414" format="subtitle2 description airRight" mode="normal" value="mostrar primero">
								</UiText>
								<UiSorting context={this._context.bind(this)} owner={this._owner.bind(this)} id="a636866593" label="female population">
								</UiSorting>
							</UiBlock>
							<UiList context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1501457438" pageSize={20} itemHeight={60} scrollingMark={true}>
							</UiList>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_959220745" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1438718284" mode="normal" language="Html" value="Block(layout=Horizontal)
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;mostrar primero&quot;)
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Sorting(collections=list) gender1 as Labeled(&quot;female population&quot;)
							List(itemClass=&quot;io.intino.alexandria.ui.documentation.Person&quot;) list&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold &gt; Item(height=60px,width=30%) sortingMold&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text firstName&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(layout=Horizontal, spacing=DP16)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(format=description) gender&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(format=description) age as Labeled(&quot;age&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1928953029" layout="vertical" width="49.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1578318035" format="h6" mode="normal" value="Sortings inside Selector">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1093527084" format="filledNoAir" layout="vertical" spacing="8">
							<UiSelectorComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2094353876" format="air" multipleSelection={true}>
								<UiSorting context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1446940294" name="youthest" label="youthest population">
								</UiSorting>
								<UiSorting context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1249351538" name="oldest" label="oldest population">
								</UiSorting>
								<UiSorting context={this._context.bind(this)} owner={this._owner.bind(this)} id="a985488575" name="female" label="female population">
								</UiSorting>
								<UiSorting context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_164132800" name="male" label="male population">
								</UiSorting>
							</UiSelectorComboBox>
							<UiList context={this._context.bind(this)} owner={this._owner.bind(this)} id="a145690663" pageSize={20} itemHeight={60} scrollingMark={true}>
							</UiList>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1117009194" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a509560498" mode="normal" language="Html" value="Selector as ComboBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;multipleSelection=true&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Sorting(collections=list) as Option(&quot;youthest&quot;) Labeled(&quot;youthest population&quot;)
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Sorting(collections=list) as Option(&quot;oldest&quot;) Labeled(&quot;oldest population&quot;)
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Sorting(collections=list) as Option(&quot;female&quot;) Labeled(&quot;female population&quot;)
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Sorting(collections=list) as Option(&quot;male&quot;) Labeled(&quot;male population&quot;)
							List(itemClass=&quot;io.intino.alexandria.ui.documentation.Person&quot;) list&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold &gt; Item(height=60px,width=30%) sortingMold&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text firstName&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(layout=Horizontal, spacing=DP16)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(format=description) gender&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(format=description) age as Labeled(&quot;age&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}