import React from "react";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiSlider from "alexandria-ui-elements/src/displays/components/Slider";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTemporalSlider from "alexandria-ui-elements/src/displays/components/TemporalSlider";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractSliderExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1875277320" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_265245212" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1492818315" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1325407339" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSlider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_60326974" format="containerAirLarge" arrangement="Horizontal" range={{min:1,max:100}}>
							</UiSlider>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a378482043" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2088607590" mode="normal" language="Html" value="Slider slider&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Range(min=1,max=100)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a458391271" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1470509724" format="h6" mode="normal" value="No facets with Animation property">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_917066418" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSlider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a769820324" format="containerAirLarge" arrangement="Horizontal" animation={{interval:3000,loop:true}} range={{min:1,max:100}}>
							</UiSlider>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1368827559" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1527889019" mode="normal" language="Html" value="Slider slider&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Range(min=1,max=100)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Animation(interval=100 Millis, loop=true)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1383337357" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1835904208" format="h6" mode="normal" value="Temporal facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a993551089" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiTemporalSlider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1993935096" format="containerAirLarge" arrangement="Horizontal">
							</UiTemporalSlider>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1573649980" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a393621654" mode="normal" language="Html" value="TemporalSlider slider&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Range(min=1,max=100)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;scales=Day Month Year">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2004527060" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a523995195" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1367399638" format="h6" mode="normal" value="No facets with ToolbarOnly style">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_261555746" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSlider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1157068483" format="containerAirLarge" arrangement="Horizontal" style="ToolbarOnly" range={{min:1,max:100}}>
							</UiSlider>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1800328942" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_927974013" mode="normal" language="Html" value="Slider(style=ToolbarOnly)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Range(min=1,max=100)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1718527781" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2091590720" format="h6" mode="normal" value="No facets with SliderOnly style">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_49271721" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSlider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1987215781" format="containerAirLarge" arrangement="Horizontal" style="SliderOnly" range={{min:1,max:100}}>
							</UiSlider>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1490651019" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a995144799" mode="normal" language="Html" value="Slider(style=SliderOnly)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Range(min=1,max=100)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}