import React from "react";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiSelectorTabs from "alexandria-ui-elements/src/displays/components/SelectorTabs";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiSelectorMenu from "alexandria-ui-elements/src/displays/components/SelectorMenu";
import UiSelectorComboBox from "alexandria-ui-elements/src/displays/components/SelectorComboBox";
import UiSelectorListBox from "alexandria-ui-elements/src/displays/components/SelectorListBox";
import UiSelectorRadioBox from "alexandria-ui-elements/src/displays/components/SelectorRadioBox";
import UiSelectorToggleBox from "alexandria-ui-elements/src/displays/components/SelectorToggleBox";
import UiSelectorCheckBox from "alexandria-ui-elements/src/displays/components/SelectorCheckBox";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractSelectorExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1336150149" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2020912773" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1527946473" format="h6" mode="normal" value="Tabs facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_839794990" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorTabs context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_306608826" multipleSelection={false}>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_685079136" name="tabOption1" mode="normal" value="option 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_685079135" name="tabOption2" mode="normal" value="option 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_685079134" name="tabOption3" mode="normal" value="option 3">
								</UiText>
							</UiSelectorTabs>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1366505068" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1198653486" mode="normal" language="Html" value="Selector as Tabs&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) tabOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) tabOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) tabOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a259722798" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_381311870" format="h6" mode="normal" value="Menu facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1976248529" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorMenu context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1722381804" multipleSelection={false} layout="Vertical">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1564631594" name="menuOption1" mode="normal" value="option 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1564631595" name="menuOption2" mode="normal" value="option 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1564631596" name="menuOption3" mode="normal" value="option 3">
								</UiText>
							</UiSelectorMenu>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a142036600" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1749948530" mode="normal" language="Html" value="Selector as Menu(layout=Vertical)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) menuOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) menuOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) menuOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2062052693" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_940216439" format="h6" mode="normal" value="ComboBox facet with Traceable (cookie is used)">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1834882373" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1884876583" traceable={true} multipleSelection={false}>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a578658599" name="comboBoxOption1" mode="normal" value="option 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a578658600" name="comboBoxOption2" mode="normal" value="option 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a578658601" name="comboBoxOption3" mode="normal" value="option 3">
								</UiText>
							</UiSelectorComboBox>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a83649992" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_439831613" mode="normal" language="Html" value="Selector as ComboBox Traceable&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) comboBoxOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) comboBoxOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) comboBoxOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_941360888" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1372843662" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_383503969" format="h6" mode="normal" value="ListBox facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2085174270" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_674503090" multipleSelection={false}>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1907218272" name="listBoxOption1" mode="normal" value="option 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1907218273" name="listBoxOption2" mode="normal" value="option 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1907218274" name="listBoxOption3" mode="normal" value="option 3">
								</UiText>
							</UiSelectorListBox>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1342000134" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1275139655" mode="normal" language="Html" value="Selector as ListBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) listBoxOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) listBoxOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) listBoxOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1575333986" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1260776003" format="h6" mode="normal" value="RadioBox facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a287583985" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorRadioBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_512008311" multipleSelection={false} selected="radioBoxOption1">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_20870218" name="radioBoxOption1" mode="normal" value="option 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_20870217" name="radioBoxOption2" mode="normal" value="option 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_20870216" name="radioBoxOption3" mode="normal" value="option 3">
								</UiText>
							</UiSelectorRadioBox>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1465704667" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_234761045" mode="normal" language="Html" value="Selector as RadioBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) radioBoxOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) radioBoxOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) radioBoxOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1624831738" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a381830595" format="h6" mode="normal" value="ToggleBox facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1129821265" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorToggleBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_349513532" multipleSelection={false} selected="toggleBoxOption1" layout="Horizontal" size="Medium">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a584957600" name="toggleBoxOption1" mode="normal" value="option 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a584957601" name="toggleBoxOption2" mode="normal" value="option 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a584957602" name="toggleBoxOption3" mode="normal" value="option 3">
								</UiText>
							</UiSelectorToggleBox>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1972104905" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_613461212" mode="normal" language="Html" value="Selector as ToggleBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) toggleBoxOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) toggleBoxOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) toggleBoxOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a458506938" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1626990045" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1949869661" format="h6" mode="normal" value="CheckBox facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1208411741" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorCheckBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_765731418" multipleSelection={false}>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1142936736" name="checkBoxOption1" mode="normal" value="option 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1142936737" name="checkBoxOption2" mode="normal" value="option 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1142936738" name="checkBoxOption3" mode="normal" value="option 3">
								</UiText>
							</UiSelectorCheckBox>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a433109100" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1350127725" mode="normal" language="Html" value="Selector as CheckBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) checkBoxOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) checkBoxOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) checkBoxOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}