import React from "react";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiNumber from "alexandria-ui-elements/src/displays/components/Number";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiNumberEditable from "alexandria-ui-elements/src/displays/components/NumberEditable";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractNumberExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1803026842" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_616837844" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1350251893" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_460608586" format="filled" layout="vertical" spacing="8">
							<UiNumber context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1741434098" format="body1 widgetDemo" style="Number" value={0.0} decimals={0} expanded={true}>
							</UiNumber>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a684227804" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1115528958" mode="normal" language="Html" value="Number(value=10, label=&quot;Campo num&eacute;rico&quot;) number1&lt;br/&gt;
								in java called to number1.countDecimals(10)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_163325254" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1893159615" format="h6" mode="normal" value="No facets with prefix and suffix">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2141222176" format="filled" layout="vertical" spacing="8">
							<UiNumber context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1870516818" format="body1 widgetDemo" style="Number" value={0.0} prefix="Amount" suffix="$" decimals={0} expanded={true}>
							</UiNumber>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1099815553" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1625139614" mode="normal" language="Html" value="Number(format=body1 widgetDemo, value=0, prefix=&quot;Amount&quot;, suffix=&quot;$&quot;) number1">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1528596358" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_195685815" format="h6" mode="normal" value="Editable facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1573278486" format="filled" layout="vertical" spacing="8">
							<UiNumberEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1417143524" format="body1 widgetDemo" style="Number" value={0.0} prefix="Price:" suffix="$" min={0.0} max={100.0} step={10.0} decimals={0} expanded={true}>
							</UiNumberEditable>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1641653903" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a652665217" mode="normal" language="Html" value="Number(format=body1 widgetDemo, value=0, min=0, max=100, step=10, prefix=&quot;Price:&quot;, suffix=&quot;$&quot;) number2 as Editable">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1931050847" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_367692044" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a970231290" format="h6" mode="normal" value="No facets, Currency style">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1491020515" format="filled" layout="vertical" spacing="8">
							<UiNumber context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_128293944" format="body1 widgetDemo" style="Currency" value={1.0E8} decimals={2} expanded={true}>
							</UiNumber>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1755879761" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a319454866" mode="normal" language="Html" value="Number(value=100000000, style=Currency, countDecimals=2)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_151740408" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1540283932" format="h6" mode="normal" value="No facets, Bytes style">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_4368432" format="filled" layout="vertical" spacing="8">
							<UiNumber context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1533552412" format="body1 widgetDemo" style="Bytes" value={2.3232323E7} decimals={2} expanded={true}>
							</UiNumber>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_353340736" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_39439303" mode="normal" language="Html" value="Number(value=23232323, style=Bytes, countDecimals=2)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1839124396" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_326049555" format="h6" mode="normal" value="No facets, Exponential style">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a674341216" format="filled" layout="vertical" spacing="8">
							<UiNumber context={this._context.bind(this)} owner={this._owner.bind(this)} id="a498521700" format="body1 widgetDemo" style="Exponential" value={1.2398734202E7} decimals={2} expanded={true}>
							</UiNumber>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1547158594" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1634980066" mode="normal" language="Html" value="Number(value=12398734.202, style=Exponential, countDecimals=2)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}