import React from "react";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiMap from "alexandria-ui-elements/src/displays/components/Map";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import DisplaysMap1Mold from "ui-elements/gen/displays/items/Map1Mold";
import DisplaysMap2Mold from "ui-elements/gen/displays/items/Map2Mold";
import DisplaysMap3Mold from "ui-elements/gen/displays/items/Map3Mold";
import DisplaysMap4Mold from "ui-elements/gen/displays/items/Map4Mold";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractMapExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1181661835" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_201134418" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a327229792" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1676454145" format="filledNoAirLarge" layout="vertical" spacing="8">
							<UiMap context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1273002339" itemHeight={60} center={{lat:28.146773457066104,lng:-15.418557420532238}} zoom={{min:1,max:18,defaultZoom:6}}>
							</UiMap>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2027751702" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2119044819" mode="normal" language="Html" value="Map(itemClass=&quot;io.intino.alexandria.ui.documentation.Item&quot;) map&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;icon=&quot;icons/placemark.png&quot;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Zoom(defaultZoom=14, min=1, max=18)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Center(latitude=28.146773457066104, longitude=-15.418557420532238)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold &gt; Item mapMold &gt; Stamp(template=itemMold) stamp&lt;br/&gt;&lt;br/&gt;

							Template(modelClass=&quot;io.intino.alexandria.ui.documentation.Item&quot;) itemMold&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(layout=Horizontal Center, spacing=DP8)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Image avatar as Avatar&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text label">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1494357190" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a959745722" format="h6" mode="normal" value="Clustered facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a896375694" format="filledNoAirLarge" layout="vertical" spacing="8">
							<UiMap context={this._context.bind(this)} owner={this._owner.bind(this)} id="a340519741" type="Cluster" itemHeight={60} center={{lat:28.146773457066104,lng:-15.418557420532238}} zoom={{min:1,max:18,defaultZoom:4}}>
							</UiMap>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a989047259" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a229554288" mode="normal" language="Html" value="Map(itemClass=&quot;io.intino.alexandria.ui.documentation.Item&quot;) map as Clustered&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Zoom(defaultZoom=14, min=1, max=18)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Center(latitude=28.146773457066104, longitude=-15.418557420532238)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold &gt; Item mapMold &gt; Stamp(template=itemMold) stamp&lt;br/&gt;&lt;br/&gt;

							Template(modelClass=&quot;io.intino.alexandria.ui.documentation.Item&quot;) itemMold&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(layout=Horizontal Center, spacing=DP8)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Image avatar as Avatar&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text label">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1879422352" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_541163538" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2095491991" format="h6" mode="normal" value="Heatmap facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1941479145" format="filledNoAirLarge" layout="vertical" spacing="8">
							<UiMap context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211231486" type="Heatmap" itemHeight={60} center={{lat:28.146773457066104,lng:-15.418557420532238}} zoom={{min:1,max:18,defaultZoom:4}}>
							</UiMap>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_973466867" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a934227350" mode="normal" language="Html" value="Map(itemClass=&quot;io.intino.alexandria.ui.documentation.Item&quot;) map as Heatmap&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Zoom(defaultZoom=14, min=1, max=18)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Center(latitude=28.146773457066104, longitude=-15.418557420532238)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold &gt; Item mapMold &gt; Stamp(template=itemMold) stamp&lt;br/&gt;&lt;br/&gt;

							Template(modelClass=&quot;io.intino.alexandria.ui.documentation.Item&quot;) itemMold&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(layout=Horizontal Center, spacing=DP8)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Image avatar as Avatar&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text label">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a785756696" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a924377553" format="h6" mode="normal" value="Kml facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1834154754" format="filledNoAirLarge" layout="vertical" spacing="8">
							<UiMap context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1660867104" type="Kml" itemHeight={60} center={{lat:28.146773457066104,lng:-15.418557420532238}} zoom={{min:1,max:18,defaultZoom:4}}>
							</UiMap>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2035964977" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1181649807" mode="normal" language="Html" value="Map(itemClass=&quot;io.intino.alexandria.ui.documentation.Item&quot;) map as Kml(layer=&quot;data/example.kml&quot;)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Zoom(defaultZoom=14, min=1, max=18)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Center(latitude=28.146773457066104, longitude=-15.418557420532238)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold &gt; Item mapMold &gt; Stamp(template=itemMold) stamp&lt;br/&gt;&lt;br/&gt;

							Template(modelClass=&quot;io.intino.alexandria.ui.documentation.Item&quot;) itemMold&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(layout=Horizontal Center, spacing=DP8)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Image avatar as Avatar&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text label">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}