import React from "react";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiImage from "alexandria-ui-elements/src/displays/components/Image";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiImageAvatar from "alexandria-ui-elements/src/displays/components/ImageAvatar";
import UiImageEditable from "alexandria-ui-elements/src/displays/components/ImageEditable";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractImageExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1119114913" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a127894937" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1259159685" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1506365450" format="filled" layout="vertical" spacing="8">
							<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1277175006" format="widgetDemo" width="200px" height="150px">
							</UiImage>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a3761980" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a255058056" mode="normal" language="Html" value="Image(defaultValue=&quot;images/image.jpg&quot;, format=widgetDemo) image1 as Absolute(width=300px, height=150px)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a880780785" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_496890326" format="h6" mode="normal" value="Avatar facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1182814384" format="filled" layout="vertical" spacing="8">
							<UiImageAvatar context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_519776352" format="widgetDemo" color="#3F52B5" width="75px" height="75px">
							</UiImageAvatar>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a357193558" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1763533386" mode="normal" language="Html" value="Image image2 as Avatar(&quot;Intino avatar&quot;, format=widgetDemo, color=&quot;#3F52B5&quot;) Absolute(width=75px, height=75px)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a193453643" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a839769067" format="h6" mode="normal" value="Editable facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1349155415" format="filled" layout="vertical" spacing="8">
							<UiImageEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1978239586" format="widgetDemo" width="200px" height="200px">
							</UiImageEditable>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1320378030" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1022958580" mode="normal" language="Html" value="Image(defaultValue=&quot;images/image.jpg&quot;) image3 as Editable(format=widgetDemo) Absolute(width=200px, height=200px)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}