import React from "react";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiGrouping from "alexandria-ui-elements/src/displays/components/Grouping";
import UiList from "alexandria-ui-elements/src/displays/components/List";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiGroupingComboBox from "alexandria-ui-elements/src/displays/components/GroupingComboBox";
import DisplaysGrouping1Mold from "ui-elements/gen/displays/items/Grouping1Mold";
import DisplaysGrouping2Mold from "ui-elements/gen/displays/items/Grouping2Mold";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractGroupingExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_790662810" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a819236413" layout="vertical" width="49.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1917983029" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a558366290" format="filledNoAir" layout="horizontal" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_329496262" format="containerAirMedium" layout="vertical" width="200px" height="-1px" spacing="24">
								<UiGrouping context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1140258110" label="gender" format="whiteBackground" pageSize={5}>
								</UiGrouping>
								<UiGrouping context={this._context.bind(this)} owner={this._owner.bind(this)} id="a658203683" label="age group" format="whiteBackground" pageSize={5}>
								</UiGrouping>
							</UiBlock>
							<UiList context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1145765181" pageSize={20} itemHeight={60} scrollingMark={true}>
							</UiList>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a833022826" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a793741042" mode="normal" language="Html" value="Grouping(collections=list1) gender as Labeled(&quot;gender&quot;)&lt;br/&gt;
							Grouping(collections=list1) ageGroup as Labeled(&quot;age group&quot;)&lt;br/&gt;
							List(itemClass=&quot;io.intino.alexandria.ui.documentation.Person&quot;) list&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold &gt; Item(height=60px,width=30%) groupingMold
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text firstName
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(layout=Horizontal, spacing=DP16)
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(format=description) gender
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(format=description) age as Labeled(&quot;age&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a748040586" layout="vertical" width="49.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1628564088" format="h6" mode="normal" value="ComboBox facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_861984547" format="filledNoAir" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1458077993" format="containerAirMedium" layout="horizontal" spacing="24">
								<UiGroupingComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1276914874" label="gender" format="whiteBackground">
								</UiGroupingComboBox>
								<UiGroupingComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1819928601" label="age group" format="whiteBackground">
								</UiGroupingComboBox>
							</UiBlock>
							<UiList context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1986129913" pageSize={20} itemHeight={60} scrollingMark={true}>
							</UiList>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1712719763" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_159240922" mode="normal" language="Html" value="Grouping(collections=list2) gender as Labeled(&quot;gender&quot;) ComboBox&lt;br/&gt;
							Grouping(collections=list2) ageGroup as Labeled(&quot;age group&quot;) ComboBox&lt;br/&gt;
							List(itemClass=&quot;io.intino.alexandria.ui.documentation.Person&quot;) list2&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold &gt; Item(height=60px,width=30%) groupingMold
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text firstName
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(layout=Horizontal, spacing=DP16)
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(format=description) gender
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(format=description) age as Labeled(&quot;age&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2139862200" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2111958527" layout="vertical" width="49.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_959685556" format="h6" mode="normal" value="No facets with many options">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1019935656" format="filledNoAir" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1205955608" format="containerAirMedium" layout="vertical" width="100.0%" height="100.0%" spacing="24">
								<UiGrouping context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_212311475" label="country" format="whiteBackground" pageSize={6}>
								</UiGrouping>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_194647227" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1021265706" mode="normal" language="Html" value="Grouping(collections=empty) country as Labeled(&quot;country&quot;)&lt;br/&gt;">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a104879528" layout="vertical" width="49.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_637976538" format="h6" mode="normal" value="ComboBox facet with many options">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1871504390" format="filledNoAir" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1128212264" format="containerAirMedium" layout="vertical" width="100.0%" height="100.0%" spacing="24">
								<UiGroupingComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_376631762" label="country" format="whiteBackground">
								</UiGroupingComboBox>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a983132233" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1691374289" mode="normal" language="Html" value="Grouping(collections=empty) country as Labeled(&quot;country&quot;) ComboBox&lt;br/&gt;">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}