import React from "react";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiFile from "alexandria-ui-elements/src/displays/components/File";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiFileEditable from "alexandria-ui-elements/src/displays/components/FileEditable";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractFileExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1730480541" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1749644620" layout="vertical" width="50.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_277089621" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a392737777" format="filled" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a260118974" layout="vertical" width="-1px" height="600px">
								<UiFile context={this._context.bind(this)} owner={this._owner.bind(this)} id="a899204558" format="widgetDemo" width="100.0%" height="100.0%">
								</UiFile>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a922021415" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1781226973" mode="normal" language="Html" value="File(value=&quot;data/example.pdf&quot;) as Relative(width=100%, height=100%)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1933668763" layout="vertical" width="50.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1981468480" format="h6" mode="normal" value="Editable facet with drop zone">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1997342575" format="filled" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1101019127" layout="vertical" width="-1px" height="600px">
								<UiFileEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a702691054" format="widgetDemo" width="100.0%" height="100.0%" dropZone={true}>
								</UiFileEditable>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_430298354" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1276591869" mode="normal" language="Html" value="File(value=&quot;data/example.pdf&quot;) as Relative(width=100%, height=100%) Editable(showDropZone=true)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}