import React from "react";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiExport from "alexandria-ui-elements/src/displays/components/Export";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractExportExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1937325936" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_609685755" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_587359377" format="h6" mode="normal" value="No facets with from">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a909536641" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiExport context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1577127772" title="export..." target="self" mode="Button" size="Medium" from={1322870400000} range={{min:-1,max:-1}}>
							</UiExport>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a910160186" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_688349890" mode="normal" language="Html" value="Export(title=&quot;export...&quot;, from=&quot;2011-12-03T00:00:00Z&quot;) as Button">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_535623468" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1219516365" format="h6" mode="normal" value="No facets with from and to">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1780058811" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiExport context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1706210492" title="export..." target="self" mode="Button" size="Medium" from={1322870400000} to={1323302400000} min={1322697600000} max={1325289600000} range={{min:-1,max:7}}>
							</UiExport>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_706500109" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a139648451" mode="normal" language="Html" value="Button(title=&quot;export...&quot;) as Export&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;from=&quot;2011-12-03T00:00:00Z&quot;&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;to=&quot;2011-12-03T00:00:00Z&quot;&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;min=&quot;2011-12-03T00:00:00Z&quot;&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;max=&quot;2011-12-03T00:00:00Z&quot;&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;rangeMax=7 Days">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1428795719" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a429158108" format="h6" mode="normal" value="No facets with options">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a155193301" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiExport context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1964375931" title="export..." target="self" mode="Button" size="Medium" range={{min:-1,max:-1}} options={["a","b"]}>
							</UiExport>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1541671882" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a880086964" mode="normal" language="Html" value="Button(title=&quot;export...&quot;) as Export(options=&quot;a&quot; &quot;b&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}