import React from "react";
import UiStamp from "alexandria-ui-elements/src/displays/components/Stamp";
import UiHeader from "alexandria-ui-elements/src/displays/components/Header";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiImage from "alexandria-ui-elements/src/displays/components/Image";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiOpenPage from "alexandria-ui-elements/src/displays/components/OpenPage";
import UiMultiple from "alexandria-ui-elements/src/displays/components/Multiple";
import DisplaysWidgetSummaryMold from "ui-elements/src/displays/templates/WidgetSummaryMold";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractDocsTemplate extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<UiBlock layout="vertical" style={{...this.props.style,...display}}>
				<UiHeader context={this._context.bind(this)} owner={this._owner.bind(this)} id="a482157194" format="air" color="white" position="relative" width="-1px" height="100px" elevation={4}>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_745642271" layout="horizontal center" spacing="24">
						<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a97659331" width="80px" height="80px">
						</UiImage>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a866041039" format="h3" mode="normal" value="intino">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_433533055" format="headerToolbar" layout="horizontal center" spacing="24">
							<UiOpenPage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1504304905" title="home" target="self" mode="Link" size="Medium">
							</UiOpenPage>
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a671831407" mode="normal" value="docs">
							</UiText>
						</UiBlock>
					</UiBlock>
				</UiHeader>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1642819251" format="containerAirLarge" layout="wrap" spacing="40">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_149344623" label="data widgets" format="h5 paperFormat" layout="vertical" spacing="8">
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1887322377" multiple={{instances:"dataWidgets",arrangement:"Horizontal",noItemsMessage:"no widgets",spacing:16,wrap:true}}>
						</UiMultiple>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1376863834" label="catalog widgets" format="h5 paperFormat" layout="vertical" spacing="8">
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1972960271" multiple={{instances:"catalogWidgets",arrangement:"Horizontal",noItemsMessage:"no widgets",spacing:16,wrap:true}}>
						</UiMultiple>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1885192344" label="operation widgets" format="h5 paperFormat" layout="vertical" spacing="8">
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1764951055" multiple={{instances:"operationWidgets",arrangement:"Horizontal",noItemsMessage:"no widgets",spacing:16,wrap:true}}>
						</UiMultiple>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1326767729" label="other widgets" format="h5 paperFormat" layout="vertical" spacing="8">
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a693468719" multiple={{instances:"otherWidgets",arrangement:"Horizontal",noItemsMessage:"no widgets",spacing:16,wrap:true}}>
						</UiMultiple>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}