import React from "react";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiOpenDialog from "alexandria-ui-elements/src/displays/components/OpenDialog";
import UiDialog from "alexandria-ui-elements/src/displays/components/Dialog";
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import UiCloseDialog from "alexandria-ui-elements/src/displays/components/CloseDialog";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiDecisionDialog from "alexandria-ui-elements/src/displays/components/DecisionDialog";
import UiSelectorListBox from "alexandria-ui-elements/src/displays/components/SelectorListBox";
import UiImageAvatar from "alexandria-ui-elements/src/displays/components/ImageAvatar";
import UiAlertDialog from "alexandria-ui-elements/src/displays/components/AlertDialog";
import UiCollectionDialog from "alexandria-ui-elements/src/displays/components/CollectionDialog";
import UiList from "alexandria-ui-elements/src/displays/components/List";
import DisplaysDialog4ListMold from "ui-elements/gen/displays/items/Dialog4ListMold";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractDialogExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a503161222" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1780753025" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a250813419" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_307266296" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiOpenDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1558213555" title="custom dialog" target="self" mode="Button" size="Medium">
							</UiOpenDialog>
							<UiDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_671637708" format="containerAirLarge" title="custom dialog">
								<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_566617630" mode="normal" placeholder="field 1">
								</UiTextEditable>
								<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_566617629" mode="normal" placeholder="field 2">
								</UiTextEditable>
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1508771670" format="airTop" layout="horizontal endjustified" spacing="8">
									<UiCloseDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a476937857" title="Close" target="self" mode="Button" size="Medium">
									</UiCloseDialog>
									<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_490525048" title="Accept" target="self" mode="Button" size="Medium">
									</UiAction>
								</UiBlock>
							</UiDialog>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1152941688" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1143020892" mode="normal" language="Html" value="Button(title=&quot;custom dialog&quot;) as OpenDialog(dialog=dialog)
							Dialog(format=containerAirLarge, title = &quot;custom dialog&quot;) dialog
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text field1 as Editable
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text field2 as Editable
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(layout=Horizontal EndJustified)
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Button(title=&quot;Close&quot;) as CloseDialog(dialog=dialog)
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Button(title=&quot;Accept&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2100691911" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1393940887" format="h6" mode="normal" value="No facets. Decision dialog">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1550940536" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiOpenDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a953156242" title="decision dialog" target="self" mode="Button" size="Medium">
							</UiOpenDialog>
							<UiDecisionDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a287592309" format="containerAirLarge" title="decision dialog">
								<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_724778008" multipleSelection={false}>
									<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a158632197" name="option1" layout="horizontal center" spacing="8">
										<UiImageAvatar context={this._context.bind(this)} owner={this._owner.bind(this)} id="a605530512">
										</UiImageAvatar>
										<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1591765539" mode="normal" value="Option 1">
										</UiText>
									</UiBlock>
									<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a158632198" name="option2" layout="horizontal center" spacing="8">
										<UiImageAvatar context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1290048315">
										</UiImageAvatar>
										<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_907307072" mode="normal" value="Option 2">
										</UiText>
									</UiBlock>
								</UiSelectorListBox>
							</UiDecisionDialog>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a218630354" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1847092184" mode="normal" language="Html" value="Button(title=&quot;decision dialog&quot;) as OpenDialog(dialog=dialog)
							DecisionDialog(format=containerAirLarge, title = &quot;decision dialog&quot;) dialog
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Selector selector1 as ComboBox
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text option1 as Option Labeled(&quot;Option 1&quot;)
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text option2 as Option Labeled(&quot;Option 2&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_719433692" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1358610524" format="h6" mode="normal" value="No facets. Alert dialog">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a401108164" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiOpenDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1842528008" title="alert dialog" target="self" mode="Button" size="Medium">
							</UiOpenDialog>
							<UiAlertDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1246822326" format="containerAirLarge" title="alert dialog" message="Intino is cool!" closeLabel="OK!" width="350px" height="-1px">
							</UiAlertDialog>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2098296602" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_299129005" mode="normal" language="Html" value="Button(title=&quot;alert dialog&quot;) as OpenDialog(dialog=dialog)
							AlertDialog(format=containerAirLarge, title = &quot;alert dialog&quot;) dialog as Absolute(width=350px)
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;message = &quot;Intino is cool!&quot;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;acceptLabel = &quot;OK!&quot;">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_338138887" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_66014957" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2117836594" format="h6" mode="normal" value="No facets. Collection dialog">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1736568819" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiOpenDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a418469468" title="collection dialog" target="self" mode="Button" size="Medium">
							</UiOpenDialog>
							<UiCollectionDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1694092750" format="containerAirLarge" title="collection dialog" width="80.0%" height="60.0%">
								<UiList context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1286599930" pageSize={20} itemHeight={30} scrollingMark={true} selection="single">
								</UiList>
							</UiCollectionDialog>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a351436114" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a628684607" mode="normal" language="Html" value="Button(title=&quot;collection dialog&quot;) as OpenDialog(dialog=dialog)
							CollectionDialog(format=containerAirLarge, title = &quot;collection dialog&quot;) dialog
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;allowSearch = true
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;List list1 as Selectable &gt; Mold &gt; Item(height = 100px) itemMold">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1935709563" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1853002441" format="h6" mode="normal" value="Fullscreen facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1675452517" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiOpenDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a963469980" title="fullscreen dialog" target="self" mode="Button" size="Medium">
							</UiOpenDialog>
							<UiAlertDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1258767655" format="containerAirLarge" title="full screen dialog" fullscreen={true} message="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce lobortis lacinia leo, sed fringilla libero. Pellentesque at venenatis orci. Sed enim sem, blandit vel massa ut, semper blandit sapien. Suspendisse potenti. Etiam euismod nibh a scelerisque placerat. Duis maximus eget ipsum pretium auctor. Mauris malesuada metus vel dolor laoreet, eget mollis mauris condimentum. Interdum et malesuada fames ac ante ipsum primis in faucibus. Nam id nisl nibh. Mauris mattis nulla non lacinia tincidunt. Ut id orci sit amet nisl viverra rutrum in eu neque.
							                               Donec ac ex in nisl feugiat sagittis. Curabitur vehicula sed felis nec blandit. Mauris eu urna at dui feugiat laoreet. Aliquam iaculis feugiat scelerisque. Maecenas suscipit est mauris, non aliquet metus molestie in. Suspendisse finibus malesuada ante et dapibus. Mauris et dapibus massa, eu posuere nunc. Ut a lacus lectus. Morbi non vulputate eros. Morbi egestas vehicula risus, egestas sollicitudin velit elementum in. Nulla ut euismod tortor. Vestibulum tempor justo fringilla mollis hendrerit." closeLabel="OK!" width="350px" height="-1px">
							</UiAlertDialog>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a377022328" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1590384587" mode="normal" language="Html" value="Button(title=&quot;fullscreen dialog&quot;) as OpenDialog(dialog=dialog)
							AlertDialog(format=containerAirLarge, title = &quot;full screen dialog&quot;) dialog as Absolute(width=350px) Fullscreen
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;message = &quot;Intino is cool!&quot;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;acceptLabel = &quot;OK!&quot;">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1342779377" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a292657114" format="h6" mode="normal" value="Modal facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1622215388" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiOpenDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1350164873" title="modal dialog" target="self" mode="Button" size="Medium">
							</UiOpenDialog>
							<UiAlertDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a930665026" format="containerAirLarge" title="full screen dialog" modal={true} message="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce lobortis lacinia leo, sed fringilla libero. Pellentesque at venenatis orci. Sed enim sem, blandit vel massa ut, semper blandit sapien. Suspendisse potenti. Etiam euismod nibh a scelerisque placerat. Duis maximus eget ipsum pretium auctor. Mauris malesuada metus vel dolor laoreet, eget mollis mauris condimentum. Interdum et malesuada fames ac ante ipsum primis in faucibus. Nam id nisl nibh. Mauris mattis nulla non lacinia tincidunt. Ut id orci sit amet nisl viverra rutrum in eu neque.
							                               Donec ac ex in nisl feugiat sagittis. Curabitur vehicula sed felis nec blandit. Mauris eu urna at dui feugiat laoreet. Aliquam iaculis feugiat scelerisque. Maecenas suscipit est mauris, non aliquet metus molestie in. Suspendisse finibus malesuada ante et dapibus. Mauris et dapibus massa, eu posuere nunc. Ut a lacus lectus. Morbi non vulputate eros. Morbi egestas vehicula risus, egestas sollicitudin velit elementum in. Nulla ut euismod tortor. Vestibulum tempor justo fringilla mollis hendrerit." closeLabel="OK!" width="60.0%" height="40.0%">
							</UiAlertDialog>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_921488238" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1636267140" mode="normal" language="Html" value="Button(title=&quot;fullscreen dialog&quot;) as OpenDialog(dialog=dialog)
							AlertDialog(format=containerAirLarge, title = &quot;full screen dialog&quot;) dialog as Absolute(width=350px) Modal
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;message = &quot;Intino is cool!&quot;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;acceptLabel = &quot;OK!&quot;">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}