import React from "react";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiDashboardShiny from "alexandria-ui-elements/src/displays/components/DashboardShiny";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiDashboardMetabase from "alexandria-ui-elements/src/displays/components/DashboardMetabase";
import UiNumberEditable from "alexandria-ui-elements/src/displays/components/NumberEditable";
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractDashboardExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1558754923" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_44231792" layout="vertical" width="100.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1677867207" format="h6" mode="normal" value="Shiny facet with adminMode(true)">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1223998319" format="filledNoAirExtraLarge" layout="vertical">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_954355189" layout="vertical" width="-1px" height="600px">
								<UiDashboardShiny context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1060957900">
								</UiDashboardShiny>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1479820424" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1543656356" mode="normal" language="Html" value="Dashboard dashboard as Shiny&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;serverScript = &quot;data/dashboard/server.R&quot;&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;uiScript = &quot;data/dashboard/ui.R&quot;&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Parameter(&quot;param1&quot;, &quot;abcd&quot;)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_542838597" layout="vertical" width="100.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_117348302" format="h6" mode="normal" value="Metabase facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a201698605" format="filledNoAirExtraLarge" layout="vertical">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_789788684" layout="vertical" width="-1px" height="600px">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a443511797" layout="vertical flexible">
									<UiDashboardMetabase context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1422271609">
									</UiDashboardMetabase>
								</UiBlock>
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1362934850" format="air" layout="horizontal end centercenter">
									<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1043242781" format="airRight" layout="vertical" width="100px" height="-1px">
										<UiNumberEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1817518616" label="Dashboard" style="Number" value={0.0} min={0.0} max={1000.0} step={-1.0} decimals={0} expanded={true}>
										</UiNumberEditable>
									</UiBlock>
									<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_78800943" label="Secret Key" mode="normal" placeholder="Fill secret key provided by Metabase">
									</UiTextEditable>
								</UiBlock>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a359108641" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a987874541" mode="normal" language="Html" value="Dashboard dashboard as Metabase&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;url = &quot;http://localhost:3000&quot;&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;secretKey = &quot;&quot;&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}