import React from "react";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiActionSwitch from "alexandria-ui-elements/src/displays/components/ActionSwitch";
import UiActionToggle from "alexandria-ui-elements/src/displays/components/ActionToggle";
import UiActionSplit from "alexandria-ui-elements/src/displays/components/ActionSplit";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractActionableExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a170402855" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a381949611" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1863793769" format="h6" mode="normal" value="Link">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_197984941" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1047427129" title="operation" target="self" mode="Link" size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1046957341" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1854194042" mode="normal" language="Html" value="Link(title=&quot;operation&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a704118809" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2095284931" format="h6" mode="normal" value="Button">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1713276362" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a460124681" title="operation" target="self" mode="Button" size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1341359035" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2055407935" mode="normal" language="Html" value="Button(title=&quot;operation&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a452905818" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_29502315" format="h6" mode="normal" value="IconButton">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_938156233" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1967676491" title="operation" target="self" mode="IconButton" size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1438853083" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1430284333" mode="normal" language="Html" value="IconButton(title=&quot;operation&quot;, icon=&quot;/icons/operation.png&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2082757869" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a594768056" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2140155691" format="h6" mode="normal" value="MaterialIconButton">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_648416058" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1830856245" title="operation" target="self" mode="MaterialIconButton" icon="Add" size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1016151200" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a781438528" mode="normal" language="Html" value="MaterialIconButton(title=&quot;operation&quot;,icon=&quot;Add&quot;) as Action&lt;br/&gt;&lt;br/&gt;
							for icons gallery, refer to &lt;a href=&quot;https://material.io/tools/icons&quot; target=&quot;_blank&quot;&gt;material.io&lt;/a&gt;">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1351045536" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a957880143" format="h6" mode="normal" value="Affirmed facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1150726476" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_828863060" title="operation" target="self" mode="Button" affirmed="Are you sure you want to execute operation?" size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1824092322" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1418111300" mode="normal" language="Html" value="Button(title=&quot;operation&quot;) as Action Affirmed(&quot;Are you sure you want to execute operation?&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1614734879" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1593891049" format="h6" mode="normal" value="Highlight attribute">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a657087395" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a678688750" title="operation 1" target="self" mode="Button" size="Medium" highlighted="Outline">
							</UiAction>
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a678688751" title="operation 2" target="self" mode="Button" size="Medium" highlighted="Fill">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1482042037" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a980213603" mode="normal" language="Html" value="Button(title=&quot;operation 1&quot;, highlight=&quot;Outline&quot;) as Action&lt;br/&gt;
							Button(title=&quot;operation 2&quot;, highlight=&quot;Fill&quot;) as Action&lt;br/&gt;">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_572575" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_157036949" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2071922401" format="h6" mode="normal" value="Switch">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1403174621" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiActionSwitch context={this._context.bind(this)} owner={this._owner.bind(this)} id="a164006061" title="edition" target="self" mode="Link" size="Medium" state="Off">
							</UiActionSwitch>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1700272577" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1993495364" mode="normal" language="Html" value="Switch(title=&quot;edition&quot;, state=Off) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a281589140" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1186222211" format="h6" mode="normal" value="Signed facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_55276564" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1671557871" title="edition" target="self" mode="Button" signed={{text:"Fill your password before continue",reason:""}} size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2002504528" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_719178003" mode="normal" language="Html" value="Button(title=&quot;edition&quot;) as Action Signed(signText=&quot;Fill your password before continue&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_92013722" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a528112556" format="h6" mode="normal" value="Signed facet with reason property">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1528205013" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_231847928" title="edition" target="self" mode="Button" signed={{text:"Fill your password before continue",reason:"Fill reason"}} size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2103162290" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_260774178" mode="normal" language="Html" value="Button(title=&quot;edition&quot;) as Action Signed(signText=&quot;Fill your password before continue&quot;, reasonText=&quot;Fill reason&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2084864364" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a409821733" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1228729346" format="h6" mode="normal" value="Toggle">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_915851013" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiActionToggle context={this._context.bind(this)} owner={this._owner.bind(this)} id="a324361319" title="edition" target="self" mode="Toggle" size="Medium" state="Off">
							</UiActionToggle>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a416081764" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1935601138" mode="normal" language="Html" value="Toggle(title=&quot;edition&quot;, state=Off) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_792596626" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a436147655" format="h6" mode="normal" value="IconToggle">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1454855724" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiActionToggle context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_186172856" title="operation" target="self" mode="IconToggle" size="Medium" state="Off">
							</UiActionToggle>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a155033585" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2020800727" mode="normal" language="Html" value="IconToggle(title=&quot;operation&quot;, icon=&quot;/icons/operation.png&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a231253735" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2131399934" format="h6" mode="normal" value="MaterialIconToggle">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_249920199" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiActionToggle context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_696707034" title="edition" target="self" mode="MaterialIconToggle" icon="FilterList" size="Medium" state="On">
							</UiActionToggle>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_265392158" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a591643375" mode="normal" language="Html" value="MaterialIconToggle(title=&quot;edition&quot;, state=On, icon=&quot;FilterList&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1013888157" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_941305184" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a183315652" format="h6" mode="normal" value="SplitButton">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1400611560" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiActionSplit context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_893287970" title="edition" target="self" mode="SplitButton" size="Medium" options={["option 1","option 2"]} defaultOption="option 1">
							</UiActionSplit>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_744976990" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2003481558" mode="normal" language="Html" value="SplitButton(title=&quot;edition&quot;, options=&quot;option 1&quot; &quot;option 2&quot;, defaultOption=&quot;option 1&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}