import BaseSelectionActionRequester from "./BaseSelectionActionRequester"

export default class DownloadSelectionRequester extends BaseSelectionActionRequester {
	constructor(element) {
		super(element);
	};
	changeParams = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ op: "changeParams", s: "downloadselection", d: this.element.props.id, o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
	execute = () => {
	    if (this.addToHistory()) return;
	    this.fileService.download({ op: "execute", s: "downloadselection", d: this.element.props.id, o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
}