import BaseSelectorNotifier from "./BaseSelectorNotifier"

export default class SelectorComboBoxNotifier extends BaseSelectorNotifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("refreshSelection").toSelf().execute((parameters) => this.element.refreshSelection(parameters.v));
		this.when("refreshReadonly").toSelf().execute((parameters) => this.element.refreshReadonly(parameters.v));
		this.when("refreshMultipleSelection").toSelf().execute((parameters) => this.element.refreshMultipleSelection(parameters.v));
		this.pushLinked = true;
	};
}