import Notifier from "alexandria-ui-elements/src/displays/notifiers/ComponentNotifier";

export default class CollectionNotifier extends Notifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("setup").toSelf().execute((parameters) => this.element.setup(parameters.v));
		this.when("refresh").toSelf().execute(() => this.element.refresh());
		this.when("refreshItemCount").toSelf().execute((parameters) => this.element.refreshItemCount(parameters.v));
		this.when("refreshSelection").toSelf().execute((parameters) => this.element.refreshSelection(parameters.v));
		this.pushLinked = true;
	};
}