import Notifier from "alexandria-ui-elements/src/displays/notifiers/ComponentNotifier";

export default class BaseGroupingNotifier extends Notifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("refreshGroups").toSelf().execute((parameters) => this.element.refreshGroups(parameters.v));
		this.when("refreshSelection").toSelf().execute((parameters) => this.element.refreshSelection(parameters.v));
		this.pushLinked = true;
	};
}