import React from "react";
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import Table12MoldNotifier from "../notifiers/Table12MoldNotifier";
import Table12MoldRequester from "../requesters/Table12MoldRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';

export default class Table12Mold extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new Table12MoldNotifier(this);
		this.requester = new Table12MoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className="layout vertical center-justified">
				<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_672954836" mode="normal" placeholder="">
				</UiTextEditable>
			</div>
		);
	}
}

DisplayFactory.register("Table12Mold", Table12Mold);