import React from "react";
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import Table11MoldNotifier from "../notifiers/Table11MoldNotifier";
import Table11MoldRequester from "../requesters/Table11MoldRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';

export default class Table11Mold extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new Table11MoldNotifier(this);
		this.requester = new Table11MoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className="layout vertical center-justified">
				<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_681316466" mode="normal" placeholder="">
				</UiTextEditable>
			</div>
		);
	}
}

DisplayFactory.register("Table11Mold", Table11Mold);