import React from "react";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import Sorting2MoldNotifier from "../notifiers/Sorting2MoldNotifier";
import Sorting2MoldRequester from "../requesters/Sorting2MoldRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';

export default class Sorting2Mold extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new Sorting2MoldNotifier(this);
		this.requester = new Sorting2MoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className="layout vertical center-justified">
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1958293984" mode="normal">
				</UiText>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1978082375" layout="horizontal" spacing="16">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_498103545" format="description" mode="normal">
					</UiText>
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a251094365" label="age" format="description" mode="normal">
					</UiText>
				</UiBlock>
			</div>
		);
	}
}

DisplayFactory.register("Sorting2Mold", Sorting2Mold);