import React from "react";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import List5MoldNotifier from "../notifiers/List5MoldNotifier";
import List5MoldRequester from "../requesters/List5MoldRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';

export default class List5Mold extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new List5MoldNotifier(this);
		this.requester = new List5MoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className="layout vertical center-justified">
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_689014492" mode="normal">
				</UiText>
			</div>
		);
	}
}

DisplayFactory.register("List5Mold", List5Mold);