import React from "react";
import UiStamp from "alexandria-ui-elements/src/displays/components/Stamp";
import DisplaysItemMold from "ui-elements/src/displays/templates/ItemMold";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import List2MoldNotifier from "../notifiers/List2MoldNotifier";
import List2MoldRequester from "../requesters/List2MoldRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';

export default class List2Mold extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new List2MoldNotifier(this);
		this.requester = new List2MoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className="layout vertical center-justified">
				<DisplaysItemMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_870063161">
				</DisplaysItemMold>
			</div>
		);
	}
}

DisplayFactory.register("List2Mold", List2Mold);