import React from "react";
import UiStamp from "alexandria-ui-elements/src/displays/components/Stamp";
import DisplaysItemMold from "ui-elements/src/displays/templates/ItemMold";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import List1MoldNotifier from "../notifiers/List1MoldNotifier";
import List1MoldRequester from "../requesters/List1MoldRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';

export default class List1Mold extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new List1MoldNotifier(this);
		this.requester = new List1MoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className="layout vertical center-justified">
				<DisplaysItemMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_788878965">
				</DisplaysItemMold>
			</div>
		);
	}
}

DisplayFactory.register("List1Mold", List1Mold);