import React from "react";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import Grouping2MoldNotifier from "../notifiers/Grouping2MoldNotifier";
import Grouping2MoldRequester from "../requesters/Grouping2MoldRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';

export default class Grouping2Mold extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new Grouping2MoldNotifier(this);
		this.requester = new Grouping2MoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className="layout vertical center-justified">
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_296158274" mode="normal">
				</UiText>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_502869740" layout="horizontal" spacing="16">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a617609892" format="description" mode="normal">
					</UiText>
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1049977568" label="age" format="description" mode="normal">
					</UiText>
				</UiBlock>
			</div>
		);
	}
}

DisplayFactory.register("Grouping2Mold", Grouping2Mold);