import React from "react";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import Grouping1MoldNotifier from "../notifiers/Grouping1MoldNotifier";
import Grouping1MoldRequester from "../requesters/Grouping1MoldRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';

export default class Grouping1Mold extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new Grouping1MoldNotifier(this);
		this.requester = new Grouping1MoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className="layout vertical center-justified">
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1156355382" mode="normal">
				</UiText>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a977915665" layout="horizontal" spacing="16">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_164460469" format="description" mode="normal">
					</UiText>
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1993476553" label="age" format="description" mode="normal">
					</UiText>
				</UiBlock>
			</div>
		);
	}
}

DisplayFactory.register("Grouping1Mold", Grouping1Mold);