import React from "react";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import Dialog4ListMoldNotifier from "../notifiers/Dialog4ListMoldNotifier";
import Dialog4ListMoldRequester from "../requesters/Dialog4ListMoldRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';

export default class Dialog4ListMold extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new Dialog4ListMoldNotifier(this);
		this.requester = new Dialog4ListMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className="layout vertical center-justified">
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a21914830" mode="normal">
				</UiText>
			</div>
		);
	}
}

DisplayFactory.register("Dialog4ListMold", Dialog4ListMold);