import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiDisplayStamp from "alexandria-ui-elements/src/displays/components/DisplayStamp";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiMultiple from "alexandria-ui-elements/src/displays/components/Multiple";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiBlockConditional from "alexandria-ui-elements/src/displays/components/BlockConditional";
import DisplaysTextExamplesMold from "ui-elements/gen/displays/templates/TextExamplesMold";
import DisplaysNumberExamplesMold from "ui-elements/gen/displays/templates/NumberExamplesMold";
import DisplaysFileExamplesMold from "ui-elements/gen/displays/templates/FileExamplesMold";
import DisplaysImageExamplesMold from "ui-elements/gen/displays/templates/ImageExamplesMold";
import DisplaysDateExamplesMold from "ui-elements/gen/displays/templates/DateExamplesMold";
import DisplaysMultipleExamplesMold from "ui-elements/gen/displays/templates/MultipleExamplesMold";
import DisplaysChartExamplesMold from "ui-elements/gen/displays/templates/ChartExamplesMold";
import DisplaysBlockExamplesMold from "ui-elements/gen/displays/templates/BlockExamplesMold";
import DisplaysListExamplesMold from "ui-elements/gen/displays/templates/ListExamplesMold";
import DisplaysTableExamplesMold from "ui-elements/gen/displays/templates/TableExamplesMold";
import DisplaysDynamicTableExamplesMold from "ui-elements/gen/displays/templates/DynamicTableExamplesMold";
import DisplaysGridExamplesMold from "ui-elements/gen/displays/templates/GridExamplesMold";
import DisplaysMapExamplesMold from "ui-elements/gen/displays/templates/MapExamplesMold";
import DisplaysDownloadExamplesMold from "ui-elements/gen/displays/templates/DownloadExamplesMold";
import DisplaysDownloadSelectionExamplesMold from "ui-elements/gen/displays/templates/DownloadSelectionExamplesMold";
import DisplaysExportExamplesMold from "ui-elements/gen/displays/templates/ExportExamplesMold";
import DisplaysActionableExamplesMold from "ui-elements/gen/displays/templates/ActionableExamplesMold";
import DisplaysGroupingExamplesMold from "ui-elements/gen/displays/templates/GroupingExamplesMold";
import DisplaysGroupingToolbarExamplesMold from "ui-elements/gen/displays/templates/GroupingToolbarExamplesMold";
import DisplaysSortingExamplesMold from "ui-elements/gen/displays/templates/SortingExamplesMold";
import DisplaysSearchBoxExamplesMold from "ui-elements/gen/displays/templates/SearchBoxExamplesMold";
import DisplaysSliderExamplesMold from "ui-elements/gen/displays/templates/SliderExamplesMold";
import DisplaysDashboardExamplesMold from "ui-elements/gen/displays/templates/DashboardExamplesMold";
import DisplaysAppDirectoryExamplesMold from "ui-elements/gen/displays/templates/AppDirectoryExamplesMold";
import DisplaysDigitalSignatureExamplesMold from "ui-elements/gen/displays/templates/DigitalSignatureExamplesMold";
import DisplaysDialogExamplesMold from "ui-elements/gen/displays/templates/DialogExamplesMold";
import DisplaysLayerExamplesMold from "ui-elements/gen/displays/templates/LayerExamplesMold";
import DisplaysDividerExamplesMold from "ui-elements/gen/displays/templates/DividerExamplesMold";
import DisplaysUserExamplesMold from "ui-elements/gen/displays/templates/UserExamplesMold";
import DisplaysLocationExamplesMold from "ui-elements/gen/displays/templates/LocationExamplesMold";
import DisplaysSelectorExamplesMold from "ui-elements/gen/displays/templates/SelectorExamplesMold";
import DisplaysStepperExamplesMold from "ui-elements/gen/displays/templates/StepperExamplesMold";
import DisplaysFrameExamplesMold from "ui-elements/gen/displays/templates/FrameExamplesMold";
import DisplaysMicroSiteExamplesMold from "ui-elements/gen/displays/templates/MicroSiteExamplesMold";
import DisplaysHtmlViewerExamplesMold from "ui-elements/gen/displays/templates/HtmlViewerExamplesMold";
import DisplaysDateNavigatorExamplesMold from "ui-elements/gen/displays/templates/DateNavigatorExamplesMold";
import DisplaysTimelineExamplesMold from "ui-elements/gen/displays/templates/TimelineExamplesMold";
import DisplaysEventlineExamplesMold from "ui-elements/gen/displays/templates/EventlineExamplesMold";
import DisplaysReelExamplesMold from "ui-elements/gen/displays/templates/ReelExamplesMold";
import DisplaysDocumentEditorExamplesMold from "ui-elements/gen/displays/templates/DocumentEditorExamplesMold";
import DisplaysKpiExamplesMold from "ui-elements/gen/displays/templates/KpiExamplesMold";
import DisplaysPropertyMold from "ui-elements/gen/displays/templates/PropertyMold";
import DisplaysMethodMold from "ui-elements/gen/displays/templates/MethodMold";
import DisplaysEventsDisplay from "ui-elements/src/displays/EventsDisplay";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import WidgetMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import WidgetMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class WidgetMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new WidgetMoldNotifier(this);
		this.requester = new WidgetMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return this.renderDynamicLoaded(
			<UiBlock layout="vertical" style={{...this.props.style,...display}}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1078556726" format="h3" mode="normal" value="Widget">
				</UiText>
				<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_133628978" format="body1" multiple={{instances:"highlightFacets",arrangement:"Horizontal",noItemsMessage:"",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}} mode="normal" highlighted={{text:"white",background:"#679164"}}>
				</UiMultiple>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1216248666" format="airBottom body1" mode="normal">
				</UiText>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031" layout="vertical" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a1767222541" format="h5 underline" mode="normal" value="Examples">
						</UiText>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_1942827176" layout="vertical">
							<DisplaysTextExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_1942827176.a368611082">
							</DisplaysTextExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_95100684" layout="vertical">
							<DisplaysNumberExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_95100684.a1225658934">
							</DisplaysNumberExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a1352319143" layout="vertical">
							<DisplaysFileExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a1352319143.a515498196">
							</DisplaysFileExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_1299517374" layout="vertical">
							<DisplaysImageExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_1299517374.a_2135138629">
							</DisplaysImageExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a1012754649" layout="vertical">
							<DisplaysDateExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a1012754649.a_277833368">
							</DisplaysDateExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_1254200261" layout="vertical">
							<DisplaysMultipleExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_1254200261.a_1024831269">
							</DisplaysMultipleExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a606792645" layout="vertical">
							<DisplaysChartExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a606792645.a964444139">
							</DisplaysChartExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_231032460" layout="vertical">
							<DisplaysBlockExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_231032460.a_610039980">
							</DisplaysBlockExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_590792247" layout="vertical">
							<DisplaysListExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_590792247.a1796643740">
							</DisplaysListExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_265527371" layout="vertical">
							<DisplaysTableExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_265527371.a_451032472">
							</DisplaysTableExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_1384046342" layout="vertical">
							<DisplaysDynamicTableExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_1384046342.a_1413626475">
							</DisplaysDynamicTableExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a590736497" layout="vertical">
							<DisplaysGridExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a590736497.a435967074">
							</DisplaysGridExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_1914920253" layout="vertical">
							<DisplaysMapExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_1914920253.a_959772346">
							</DisplaysMapExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a942839475" layout="vertical">
							<DisplaysDownloadExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a942839475.a_236399729">
							</DisplaysDownloadExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a12075723" layout="vertical">
							<DisplaysDownloadSelectionExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a12075723.a_301350153">
							</DisplaysDownloadSelectionExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a201817695" layout="vertical">
							<DisplaysExportExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a201817695.a_1058640289">
							</DisplaysExportExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a224650811" layout="vertical">
							<DisplaysActionableExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a224650811.a1426868374">
							</DisplaysActionableExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a655605806" layout="vertical">
							<DisplaysGroupingExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a655605806.a1640089948">
							</DisplaysGroupingExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_516783777" layout="vertical">
							<DisplaysGroupingToolbarExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_516783777.a_1387163494">
							</DisplaysGroupingToolbarExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a656341995" layout="vertical">
							<DisplaysSortingExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a656341995.a1826325832">
							</DisplaysSortingExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_372240662" layout="vertical">
							<DisplaysSearchBoxExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_372240662.a_1697212265">
							</DisplaysSearchBoxExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a202466956" layout="vertical">
							<DisplaysSliderExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a202466956.a_1748225481">
							</DisplaysSliderExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_1092224645" layout="vertical">
							<DisplaysDashboardExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_1092224645.a_1352884815">
							</DisplaysDashboardExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_231099785" layout="vertical">
							<DisplaysAppDirectoryExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_231099785.a572225627">
							</DisplaysAppDirectoryExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_2071750229" layout="vertical">
							<DisplaysDigitalSignatureExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_2071750229.a_905248265">
							</DisplaysDigitalSignatureExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_1710255117" layout="vertical">
							<DisplaysDialogExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_1710255117.a834867050">
							</DisplaysDialogExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_1239955912" layout="vertical">
							<DisplaysLayerExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_1239955912.a2021793646">
							</DisplaysLayerExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_580955008" layout="vertical">
							<DisplaysDividerExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_580955008.a741444648">
							</DisplaysDividerExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a1852438518" layout="vertical">
							<DisplaysUserExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a1852438518.a1526988391">
							</DisplaysUserExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a1772613856" layout="vertical">
							<DisplaysLocationExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a1772613856.a715152840">
							</DisplaysLocationExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_251364598" layout="vertical">
							<DisplaysSelectorExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_251364598.a_674059001">
							</DisplaysSelectorExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a799191096" layout="vertical">
							<DisplaysStepperExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a799191096.a851700162">
							</DisplaysStepperExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_952975788" layout="vertical">
							<DisplaysFrameExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_952975788.a1532480341">
							</DisplaysFrameExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a1066866706" layout="vertical">
							<DisplaysMicroSiteExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a1066866706.a215194081">
							</DisplaysMicroSiteExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a587659848" layout="vertical">
							<DisplaysHtmlViewerExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a587659848.a_1097163625">
							</DisplaysHtmlViewerExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a1555249456" layout="vertical">
							<DisplaysDateNavigatorExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a1555249456.a898941213">
							</DisplaysDateNavigatorExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a2139740524" layout="vertical">
							<DisplaysTimelineExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a2139740524.a_1898386857">
							</DisplaysTimelineExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a169851509" layout="vertical">
							<DisplaysEventlineExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a169851509.a207599847">
							</DisplaysEventlineExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_1187469499" layout="vertical">
							<DisplaysReelExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_1187469499.a_1703517321">
							</DisplaysReelExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_798067949" layout="vertical">
							<DisplaysDocumentEditorExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_798067949.a_1445902921">
							</DisplaysDocumentEditorExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_1501440757" layout="vertical">
							<DisplaysKpiExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1020309053.a_1501440757.a1067766035">
							</DisplaysKpiExamplesMold>
						</UiBlockConditional>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a_322223984" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a_322223984.a1372971482" format="h5 underline" mode="normal" value="Facets">
						</UiText>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a_322223984.a_791343651" mode="normal">
						</UiText>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1966610659" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1966610659.a195001792" format="h5 underline" mode="normal" value="Properties">
						</UiText>
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a1966610659.a_177289976" multiple={{instances:"properties",arrangement:"Vertical",noItemsMessage:"no properties",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
						</UiMultiple>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a138151508" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a138151508.a_454984195" format="h5 underline" mode="normal" value="Methods">
						</UiText>
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a138151508.a_1871231936" multiple={{instances:"methods",arrangement:"Vertical",noItemsMessage:"no methods",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
						</UiMultiple>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a_186192819" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a_186192819.a502178" format="h5 underline" mode="normal" value="Events">
						</UiText>
						<UiDisplayStamp context={this._context.bind(this)} owner={this._owner.bind(this)} id="a113200031.a_186192819.a_1694961112">
						</UiDisplayStamp>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(WidgetMold));
DisplayFactory.register("WidgetMold", withStyles(styles, { withTheme: true })(withSnackbar(WidgetMold)));