import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiStepper from "alexandria-ui-elements/src/displays/components/Stepper";
import UiStep from "alexandria-ui-elements/src/displays/components/Step";
import UiImage from "alexandria-ui-elements/src/displays/components/Image";
import UiDate from "alexandria-ui-elements/src/displays/components/Date";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import StepperExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import StepperExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class StepperExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new StepperExamplesMoldNotifier(this);
		this.requester = new StepperExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a_958449551" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a_958449551.a_7394084" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a_958449551.a_969467805" format="filledNoAirExtraLarge" layout="vertical">
							<UiStepper context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a_958449551.a_969467805.a_1420588258" style="Full"    orientation="horizontal" position="bottom">
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a_958449551.a_969467805.a_1420588258.a2128704132" label="Step1">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a_958449551.a_969467805.a_1420588258.a2128704132.a1505434230" mode="normal" value="hola1">
									</UiText>
								</UiStep>
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a_958449551.a_969467805.a_1420588258.a2128704133" label="Step2">
									<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a_958449551.a_969467805.a_1420588258.a2128704133.a499910548" width="200px" height="150px">
									</UiImage>
								</UiStep>
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a_958449551.a_969467805.a_1420588258.a2128704134" label="Step3">
									<UiDate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a_958449551.a_969467805.a_1420588258.a2128704134.a1429360466" pattern="DD/MM/YYYY">
									</UiDate>
								</UiStep>
							</UiStepper>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a_958449551.a_969467805.a1326272841" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a_958449551.a_969467805.a1326272841.a_1380207179" mode="normal" language="Html" value="Stepper&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step1 as Labeled&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step1&quot;&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;hola1&quot;)&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step2 as Labeled&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step2&quot;&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Image(defaultValue =&quot; images/image.jpg&quot;) as Absolute(width = 200px, height = 150px)&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step3 as Labeled&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step3&quot;&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Date(pattern = &quot;DD/MM/YYYY&quot;)&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a2086538083" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a2086538083.a_916994366" format="h6" mode="normal" value="No facet. Position top, Orientation horizontal">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a2086538083.a_1997796874" format="filledNoAirExtraLarge" layout="vertical">
							<UiStepper context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a2086538083.a_1997796874.a_1232897957" style="Full"    orientation="horizontal" position="top">
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a2086538083.a_1997796874.a_1232897957.a_360202748" label="Step1">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a2086538083.a_1997796874.a_1232897957.a_360202748.a_1828033395" mode="normal" value="Hello">
									</UiText>
								</UiStep>
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a2086538083.a_1997796874.a_1232897957.a_360202747" label="Step2">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a2086538083.a_1997796874.a_1232897957.a_360202747.a662194256" mode="normal" value="World">
									</UiText>
								</UiStep>
							</UiStepper>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a2086538083.a_1997796874.a_1752860956" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a2086538083.a_1997796874.a_1752860956.a1121676106" mode="normal" language="Html" value="Stepper&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;position = Top&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step4 as Labeled&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step1&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;Hello&quot;)&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step5 as Labeled&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step2&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;World&quot;)&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a_397501773" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a_397501773.a440186873" format="h6" mode="normal" value="No facet. Position left, Orientation vertical">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a_397501773.a_708314521" format="filledNoAirExtraLarge" layout="vertical">
							<UiStepper context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a_397501773.a_708314521.a1536446724" style="Full"    orientation="vertical" position="left">
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a_397501773.a_708314521.a1536446724.a_1315720209" label="Step1">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a_397501773.a_708314521.a1536446724.a_1315720209.a1905997886" mode="normal" value="Hello">
									</UiText>
								</UiStep>
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a_397501773.a_708314521.a1536446724.a_1315720208" label="Step2">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a_397501773.a_708314521.a1536446724.a_1315720208.a_1925538292" mode="normal" value="World">
									</UiText>
								</UiStep>
							</UiStepper>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a_397501773.a_708314521.a_1058325307" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a_397501773.a_708314521.a_1058325307.a1522545863" mode="normal" language="Html" value="Stepper&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;position = Left&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;orientation = Vertical&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step6 as Labeled&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step1&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;Hello&quot;)&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step7 as Labeled&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step2&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;World&quot;)&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a1073371354" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a1073371354.a_504882038" format="h6" mode="normal" value="No facet. Position right, Orientation vertical">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a1073371354.a_958566934" format="filledNoAirExtraLarge" layout="vertical">
							<UiStepper context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a1073371354.a_958566934.a1853219744" style="Full"    orientation="vertical" position="right">
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a1073371354.a_958566934.a1853219744.a_506732147" label="Step1">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a1073371354.a_958566934.a1853219744.a_506732147.a388308038" mode="normal" value="Hello">
									</UiText>
								</UiStep>
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a1073371354.a_958566934.a1853219744.a_506732146" label="Step2">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a1073371354.a_958566934.a1853219744.a_506732146.a_1416431607" mode="normal" value="World">
									</UiText>
								</UiStep>
							</UiStepper>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a1073371354.a_958566934.a_939140019" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a1073371354.a_958566934.a_939140019.a1760740627" mode="normal" language="Html" value="Stepper&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;position = Right&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;orientation = Vertical&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step8 as Labeled&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step1&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;Hello&quot;)&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step9 as Labeled&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step2&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;World&quot;)&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a547895800" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a547895800.a_21074957" format="h6" mode="normal" value="MaterialIcon facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a547895800.a_526678713" format="filledNoAirExtraLarge" layout="vertical">
							<UiStepper context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a547895800.a_526678713.a246296008" style="Full"    orientation="horizontal" position="bottom">
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a547895800.a_526678713.a246296008.a_627062718" label="Step1" icon="AddCircle">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a547895800.a_526678713.a246296008.a_627062718.a_1374008543" mode="normal" value="Hello">
									</UiText>
								</UiStep>
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a547895800.a_526678713.a246296008.a_627062717" label="Step2" icon="Menu">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a547895800.a_526678713.a246296008.a_627062717.a763260965" mode="normal" value="World">
									</UiText>
								</UiStep>
							</UiStepper>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a547895800.a_526678713.a1844161890" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1455460589.a547895800.a_526678713.a1844161890.a703568629" mode="normal" language="Html" value="Stepper&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step10 as Labeled MaterialIcon&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step1&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;icon = &quot;AddCircle&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;Hello&quot;)&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step11 as Labeled MaterialIcon&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step2&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;icon = &quot;Menu&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;World&quot;)&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(StepperExamplesMold));
DisplayFactory.register("StepperExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(StepperExamplesMold)));