import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import MethodParamMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import MethodParamMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class MethodParamMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new MethodParamMoldNotifier(this);
		this.requester = new MethodParamMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="horizontal" style={{...this.props.style,...display}}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1537345245" format="h6" mode="normal">
				</UiText>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a694714684" format="h6" mode="normal" value=": ">
				</UiText>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1537143342" format="h6" mode="normal">
				</UiText>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_422803651" format="h6" mode="normal">
				</UiText>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(MethodParamMold));
DisplayFactory.register("MethodParamMold", withStyles(styles, { withTheme: true })(withSnackbar(MethodParamMold)));