import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiDateNavigator from "alexandria-ui-elements/src/displays/components/DateNavigator";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import DateNavigatorExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import DateNavigatorExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class DateNavigatorExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new DateNavigatorExamplesMoldNotifier(this);
		this.requester = new DateNavigatorExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1505599433" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1505599433.a798755857" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1505599433.a798755857.a173199444" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1505599433.a798755857.a971312992" format="filled" layout="vertical" spacing="8">
							<UiDateNavigator context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1505599433.a798755857.a971312992.a591001502">
							</UiDateNavigator>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1505599433.a798755857.a971312992.a_988265417" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1505599433.a798755857.a971312992.a_988265417.a_76799769" mode="normal" language="Html" value="DateNavigator&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Range(from=&quot;2022-01-01T00:00:00Z&quot;, to=&quot;2024-12-31T00:00:00Z&quot;)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(DateNavigatorExamplesMold));
DisplayFactory.register("DateNavigatorExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(DateNavigatorExamplesMold)));