import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTextEditableCode from "alexandria-ui-elements/src/displays/components/TextEditableCode";
import UiBlockParallax from "alexandria-ui-elements/src/displays/components/BlockParallax";
import UiOpenDrawer from "alexandria-ui-elements/src/displays/components/OpenDrawer";
import UiBlockDrawer from "alexandria-ui-elements/src/displays/components/BlockDrawer";
import UiSelectorListBox from "alexandria-ui-elements/src/displays/components/SelectorListBox";
import UiCloseDrawer from "alexandria-ui-elements/src/displays/components/CloseDrawer";
import UiDivider from "alexandria-ui-elements/src/displays/components/Divider";
import UiMaterialIcon from "alexandria-ui-elements/src/displays/components/MaterialIcon";
import UiBlockSplitter from "alexandria-ui-elements/src/displays/components/BlockSplitter";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiBlockBadge from "alexandria-ui-elements/src/displays/components/BlockBadge";
import UiOpenPopover from "alexandria-ui-elements/src/displays/components/OpenPopover";
import UiBlockPopover from "alexandria-ui-elements/src/displays/components/BlockPopover";
import UiOpenBlock from "alexandria-ui-elements/src/displays/components/OpenBlock";
import UiCloseBlock from "alexandria-ui-elements/src/displays/components/CloseBlock";
import UiBlockConditional from "alexandria-ui-elements/src/displays/components/BlockConditional";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import BlockExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import BlockExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class BlockExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new BlockExamplesMoldNotifier(this);
		this.requester = new BlockExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_397885507" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_397885507.a_507474792" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_397885507.a886208011" format="filled" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_397885507.a886208011.a_677831765" layout="vertical">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_397885507.a886208011.a_677831765.a_1749149843" format="body1 bordered" mode="normal" value="value 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_397885507.a886208011.a_677831765.a_1147078623" format="body1 bordered" mode="normal" value="value 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_397885507.a886208011.a_677831765.a_1142987264" format="body1 bordered" mode="normal" value="value 3">
								</UiText>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_397885507.a_434124908" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_397885507.a_434124908.a553526086" mode="normal" language="Html" value="Block&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;value 1&quot;)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;value 2&quot;)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;value 3&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a650650944" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a650650944.a_456534602" format="h6" mode="normal" value="No facets with spacing">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a650650944.a_1484582255" format="filled" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a650650944.a_1484582255.a1915201946" layout="vertical" spacing="8">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a650650944.a_1484582255.a1915201946.a_906745707" format="body1 bordered" mode="normal" value="value 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a650650944.a_1484582255.a1915201946.a_304674487" format="body1 bordered" mode="normal" value="value 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a650650944.a_1484582255.a1915201946.a1967587635" format="body1 bordered" mode="normal" value="value 3">
								</UiText>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a650650944.a_230646089" layout="vertical">
							<UiTextEditableCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a650650944.a_230646089.a1296820429" mode="normal" language="Html" value="DP8">
							</UiTextEditableCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a313597162" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a313597162.a_312396618" format="h6" mode="normal" value="No facets with layout">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a313597162.a_1444689347" format="filled" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a313597162.a_1444689347.a_471289927" layout="horizontal centercenter" width="-1px" height="175px" spacing="8">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a313597162.a_1444689347.a_471289927.a_1309633153" format="body1 bordered" mode="normal" value="value 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a313597162.a_1444689347.a_471289927.a_707561933" format="body1 bordered" mode="normal" value="value 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a313597162.a_1444689347.a_471289927.a_703470574" format="body1 bordered" mode="normal" value="value 3">
								</UiText>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a313597162.a_1400288517" layout="vertical">
							<UiTextEditableCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a313597162.a_1400288517.a1288619884" mode="normal" language="Html" value="Horizontal CenterCenter">
							</UiTextEditableCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_429716658" layout="vertical" width="99.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_429716658.a_1576799558" format="h6" mode="normal" value="Parallax facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_429716658.a_1915780267" format="filled" layout="vertical" spacing="8">
							<UiBlockParallax context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_429716658.a_1915780267.a611955939" layout="vertical" width="-1px" height="175px">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_429716658.a_1915780267.a611955939.a_863478665" layout="horizontal centercenter" width="100.0%" height="100.0%">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_429716658.a_1915780267.a611955939.a_863478665.a_1074932249" format="body1 higgerFont white" mode="normal" value="pencils">
									</UiText>
								</UiBlock>
							</UiBlockParallax>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_429716658.a_671706724" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_429716658.a_671706724.a_2002507186" mode="normal" language="Html" value="Block as Parallax(value=&quot;images/background1.jpg&quot;) Absolute(height=175px)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;value&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1775734329" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1775734329.a126726305" format="h6" mode="normal" value="Drawer facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1775734329.a_1208734020" format="filledNoAir" layout="vertical centercenter" spacing="8">
							<UiOpenDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1775734329.a_1208734020.a_2078817975" title="open drawer" target="self" mode="MaterialIconButton" icon="Menu" size="Medium">
							</UiOpenDrawer>
							<UiBlockDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1775734329.a_1208734020.a1328135792" layout="vertical" width="300px" height="-1px" position="Left" variant="Temporary">
								<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1775734329.a_1208734020.a1328135792.a726835031" multipleSelection={false}>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1775734329.a_1208734020.a1328135792.a726835031.a_1648695910" name="Block_68_6_01338594671" mode="normal" value="option 1">
									</UiText>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1775734329.a_1208734020.a1328135792.a726835031.a1186644676" name="Block_69_6_1458356688" mode="normal" value="option 2">
									</UiText>
								</UiSelectorListBox>
							</UiBlockDrawer>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1775734329.a353427660" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1775734329.a353427660.a_1258289322" mode="normal" language="Html" value="MaterialIconButton(title=&quot;open drawer&quot;, icon=&quot;Menu&quot;) as OpenDrawer(drawer=drawerBlock1)&lt;br/&gt;
							Block drawerBlock1 as Drawer Absolute(width=300px)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Selector as ListBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a798643220" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a798643220.a1937330367" format="h6" mode="normal" value="Drawer facet with position">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a798643220.a_185406724" format="filledNoAir" layout="vertical centercenter" spacing="8">
							<UiOpenDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a798643220.a_185406724.a_2021597071" title="open drawer" target="self" mode="MaterialIconButton" icon="Menu" size="Medium">
							</UiOpenDrawer>
							<UiBlockDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a798643220.a_185406724.a250322068" layout="vertical" width="300px" height="-1px" position="Right" variant="Temporary">
								<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a798643220.a_185406724.a250322068.a_1104848746" multipleSelection={false}>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a798643220.a_185406724.a250322068.a_1104848746.a125155028" name="Block_87_6_01338594671" mode="normal" value="option 1">
									</UiText>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a798643220.a_185406724.a250322068.a_1104848746.a1243865674" name="Block_88_6_1458356688" mode="normal" value="option 2">
									</UiText>
								</UiSelectorListBox>
							</UiBlockDrawer>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a798643220.a_1004565956" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a798643220.a_1004565956.a_562549719" mode="normal" language="Html" value="MaterialIconButton(title=&quot;open drawer&quot;, icon=&quot;Menu&quot;) as OpenDrawer(drawer=drawerBlock2)&lt;br/&gt;
							Block drawerBlock2 as Drawer(position=Right) Absolute(width=300px)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Selector as ListBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_959278356" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_959278356.a1651603117" format="h6" mode="normal" value="Drawer facet with Persistent variant">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_959278356.a156311104" format="filledNoAir" layout="vertical centercenter" spacing="8">
							<UiOpenDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_959278356.a156311104.a23682097" title="open drawer" target="self" mode="MaterialIconButton" icon="Menu" size="Medium">
							</UiOpenDrawer>
							<UiBlockDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_959278356.a156311104.a265679617" layout="vertical" width="300px" height="-1px" position="Left" variant="Persistent">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_959278356.a156311104.a265679617.a_1003150965" layout="horizontal endjustified">
									<UiCloseDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_959278356.a156311104.a265679617.a_1003150965.a_330513985" title="close" target="self" mode="MaterialIconButton" icon="ChevronLeft" size="Medium">
									</UiCloseDrawer>
								</UiBlock>
								<UiDivider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_959278356.a156311104.a265679617.a_1285092775">
								</UiDivider>
								<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_959278356.a156311104.a265679617.a_1719152015" multipleSelection={false}>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_959278356.a156311104.a265679617.a_1719152015.a756947820" name="Block_108_6_01338594671" mode="normal" value="option 1">
									</UiText>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_959278356.a156311104.a265679617.a_1719152015.a571509426" name="Block_109_6_1458356688" mode="normal" value="option 2">
									</UiText>
								</UiSelectorListBox>
							</UiBlockDrawer>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_959278356.a_884097055" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_959278356.a_884097055.a_892967243" mode="normal" language="Html" value="MaterialIconButton(title=&quot;open drawer&quot;, icon=&quot;Menu&quot;) as OpenDrawer(drawer=drawerBlock3)&lt;br/&gt;
							Block drawerBlock3 as Drawer(variant=Persistent) Absolute(width=300px)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(layout=Horizontal EndJustified) &gt; MaterialIconButton(title=&quot;close&quot;, icon=&quot;ChevronLeft&quot;) as CloseDrawer(drawer=drawerBlock3)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Divider&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Selector as ListBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1237555512" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1237555512.a1730625352" format="h6" mode="normal" value="Drawer facet with PersistentAndMini variant">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1237555512.a_93899437" format="filledNoAir" layout="horizontal">
							<UiBlockDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1237555512.a_93899437.a1440696483" layout="vertical" width="150px" height="-1px" position="Left" variant="PersistentAndMini">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1237555512.a_93899437.a1440696483.a_1362784132" layout="horizontal endjustified" width="-1px" height="45px">
									<UiCloseDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1237555512.a_93899437.a1440696483.a_1362784132.a_634076558" title="close" target="self" mode="MaterialIconButton" icon="ChevronLeft" size="Medium">
									</UiCloseDrawer>
								</UiBlock>
								<UiDivider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1237555512.a_93899437.a1440696483.a417948475">
								</UiDivider>
								<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1237555512.a_93899437.a1440696483.a1983895655" multipleSelection={false}>
									<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1237555512.a_93899437.a1440696483.a1983895655.a_2005522853" layout="horizontal" spacing="16">
										<UiMaterialIcon context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1237555512.a_93899437.a1440696483.a1983895655.a_2005522853.a1060370749" icon="Build">
										</UiMaterialIcon>
										<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1237555512.a_93899437.a1440696483.a1983895655.a_2005522853.a_1835407558" name="Block_130_75_01338594671" mode="normal" value="option 1">
										</UiText>
									</UiBlock>
									<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1237555512.a_93899437.a1440696483.a1983895655.a_860862992" layout="horizontal" spacing="16">
										<UiMaterialIcon context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1237555512.a_93899437.a1440696483.a1983895655.a_860862992.a_37982213" icon="Face">
										</UiMaterialIcon>
										<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1237555512.a_93899437.a1440696483.a1983895655.a_860862992.a1442235142" name="Block_131_74_1458356688" mode="normal" value="option 2">
										</UiText>
									</UiBlock>
								</UiSelectorListBox>
							</UiBlockDrawer>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1237555512.a_93899437.a_1729906301" format="autoHeight" layout="vertical flexible">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1237555512.a_93899437.a_1729906301.a1331204408" color="white" layout="horizontal startjustified">
									<UiOpenDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1237555512.a_93899437.a_1729906301.a1331204408.a1165051521" title="open drawer" target="self" mode="MaterialIconButton" icon="Menu" size="Medium">
									</UiOpenDrawer>
								</UiBlock>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1237555512.a_93899437.a_1729906301.a1803818561" format="containerAirMedium" mode="normal" value="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris tellus lacus, tristique vitae lectus id, tristique cursus est. Mauris dui dolor, lacinia non accumsan sed, lacinia et eros. Ut eget ornare nunc. Vestibulum at porta tellus, in fringilla tellus. Nam ultricies porta nisi, ut sagittis est lacinia ac. Nunc aliquet, lacus a malesuada pretium, arcu lectus egestas purus, vel euismod nisl ante eget augue. Proin tristique, arcu vitae vehicula cursus, odio nulla congue erat, at porttitor magna dui id quam. In hac habitasse platea dictumst. Etiam id lorem cursus, ultricies felis ut, pretium ante. Aliquam sit amet tellus tellus. Maecenas eget faucibus enim. Pellentesque rutrum augue id pulvinar pharetra. Proin purus ex, tincidunt et posuere vel, dignissim a neque. Aenean quis imperdiet lectus. Pellentesque bibendum ante tincidunt feugiat pharetra. Fusce sollicitudin, magna in mollis vulputate, nunc nunc accumsan lectus, a blandit erat felis a lectus.">
								</UiText>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1237555512.a_817210359" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1237555512.a_817210359.a_460211607" mode="normal" language="Html" value="Block(layout=Horizontal EndJustified) &gt; MaterialIconButton(title=&quot;close&quot;, icon=&quot;ChevronLeft&quot;) as CloseDrawer(drawer=drawerBlock1)
							Divider
							MaterialIconButton(title=&quot;open drawer&quot;, icon=&quot;Menu&quot;) as OpenDrawer(drawer=drawerBlock1)&lt;br/&gt;
							Block drawerBlock1 as Drawer(variant=PersistentAndMini) Absolute(width=300px)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Selector as ListBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_1383237843" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_1383237843.a_1819453006" format="h6" mode="normal" value="Drawer facet with Permanent variant">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_1383237843.a_873763842" format="filledNoAir" layout="horizontal" spacing="8">
							<UiBlockDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_1383237843.a_873763842.a_536638134" layout="vertical" width="150px" height="-1px" spacing="8" position="Left" variant="Permanent">
								<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_1383237843.a_873763842.a_536638134.a348975012" multipleSelection={false}>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_1383237843.a_873763842.a_536638134.a348975012.a_1509312852" name="Block_153_6_01338594671" mode="normal" value="option 1">
									</UiText>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_1383237843.a_873763842.a_536638134.a348975012.a_609974414" name="Block_154_6_1458356688" mode="normal" value="option 2">
									</UiText>
								</UiSelectorListBox>
							</UiBlockDrawer>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_1383237843.a2125920787" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_1383237843.a2125920787.a_1030065543" mode="normal" language="Html" value="Block drawerBlock as Drawer(variant=Permanent) Absolute(width=150px)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Selector as ListBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a147378287" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a147378287.a_341312797" format="h6" mode="normal" value="Splitter facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a147378287.a_1707819939" format="filled" layout="vertical" spacing="8">
							<UiBlockSplitter context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a147378287.a_1707819939.a_792414053" layout="horizontal" splitMobileLabel="Back">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a147378287.a_1707819939.a_792414053.a_1780310182" layout="vertical">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a147378287.a_1707819939.a_792414053.a_1780310182.a_397533087" mode="normal" value="block 1">
									</UiText>
									<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a147378287.a_1707819939.a_792414053.a_1780310182.a_1959200204" title="open 2" target="self" mode="Button" size="Medium">
									</UiAction>
								</UiBlock>
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a147378287.a_1707819939.a_792414053.a_1780310181" layout="vertical">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a147378287.a_1707819939.a_792414053.a_1780310181.a_578698198" mode="normal" value="block 2">
									</UiText>
								</UiBlock>
							</UiBlockSplitter>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a147378287.a1832881331" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a147378287.a1832881331.a_481873052" mode="normal" language="Html" value="Block(layout=Horizontal) as Splitter&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block &gt; Text(value=&quot;block 1&quot;)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block &gt; Text(value=&quot;block 2&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a130793391" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a130793391.a_460061108" format="h6" mode="normal" value="Badge facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a130793391.a407940430" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiBlockBadge context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a130793391.a407940430.a_1793427173" layout="horizontal" mode="Normal" value={10}>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a130793391.a407940430.a_1793427173.a2062193359" format="body1" mode="normal" value="value">
								</UiText>
							</UiBlockBadge>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a130793391.a_129084579" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a130793391.a_129084579.a_492844160" mode="normal" language="Html" value="Block as Badge(value=10)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;value&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_1670774099" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_1670774099.a_268667011" format="h6" mode="normal" value="Popover facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_1670774099.a385454100" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiOpenPopover context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_1670774099.a385454100.a_783568243" title="open popover" target="self" mode="Button" size="Medium" triggerEvent="MouseClick">
							</UiOpenPopover>
							<UiBlockPopover context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_1670774099.a385454100.a525496758" format="air" layout="horizontal" position="BottomCenter">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_1670774099.a385454100.a525496758.a_664046722" format="body1" mode="normal" value="popover content">
								</UiText>
							</UiBlockPopover>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_1670774099.a_1469483592" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a_1670774099.a_1469483592.a_931253758" mode="normal" language="Html" value="Button as OpenPopover(popover=popoverBlock)&lt;br/&gt;
							Block popoverBlock as Popover&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;popover content&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a615793992" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a615793992.a393420771" format="h6" mode="normal" value="Popover facet with trigger event">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a615793992.a_1305090436" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiOpenPopover context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a615793992.a_1305090436.a269983709" title="open popover" target="self" mode="Button" size="Medium" triggerEvent="MouseOver">
							</UiOpenPopover>
							<UiBlockPopover context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a615793992.a_1305090436.a_1877220865" format="air" layout="horizontal" position="BottomCenter">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a615793992.a_1305090436.a_1877220865.a446780484" format="body1" mode="normal" value="popover content">
								</UiText>
							</UiBlockPopover>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a615793992.a_1355887854" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a615793992.a_1355887854.a_1445012928" mode="normal" language="Html" value="Button as OpenPopover(popover=popoverBlock, triggerEvent=MouseOver)&lt;br/&gt;
							Block popoverBlock as Popover&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;popover content&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1772926040" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1772926040.a_837771220" format="h6" mode="normal" value="Badge facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1772926040.a276637501" format="filledNoAir" layout="vertical centercenter">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1772926040.a276637501.a1267109793" layout="vertical" width="80.0%" height="100.0%">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1772926040.a276637501.a1267109793.a_313728316" layout="horizontal center">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1772926040.a276637501.a1267109793.a_313728316.a1594159249" format="airRight bold" mode="normal" value="Section title">
									</UiText>
									<UiOpenBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1772926040.a276637501.a1267109793.a_313728316.a1413684714" title="Open" target="self" mode="MaterialIconButton" icon="ExpandMore" size="Small">
									</UiOpenBlock>
									<UiCloseBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1772926040.a276637501.a1267109793.a_313728316.a_7246367" title="Close" target="self" mode="MaterialIconButton" icon="ExpandLess" size="Small">
									</UiCloseBlock>
								</UiBlock>
								<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1772926040.a276637501.a1267109793.a_1014763699" format="topBordered" layout="vertical">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1772926040.a276637501.a1267109793.a_1014763699.a_755916933" format="body1" mode="normal" value="Section content">
									</UiText>
								</UiBlockConditional>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1772926040.a_58906260" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a25983923.a1772926040.a_58906260.a_1834812754" mode="normal" language="Html" value="Block as Relative(width=80%)
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(layout=Horizontal Center)
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;Section title&quot;, format=bold airRight)
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;MaterialIconButton(title=&quot;Open&quot;, size=Small, icon=&quot;ExpandMore&quot;) as OpenBlock(conditionalBlock)
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;MaterialIconButton(title=&quot;Close&quot;, size=Small, icon=&quot;ExpandLess&quot;) as CloseBlock(conditionalBlock)
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(format=topBordered) conditionalBlock as Conditional
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;Section content&quot;, format=body1)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(BlockExamplesMold));
DisplayFactory.register("BlockExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(BlockExamplesMold)));