import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiActionSwitch from "alexandria-ui-elements/src/displays/components/ActionSwitch";
import UiActionToggle from "alexandria-ui-elements/src/displays/components/ActionToggle";
import UiActionSplit from "alexandria-ui-elements/src/displays/components/ActionSplit";
import UiCopyToClipboard from "alexandria-ui-elements/src/displays/components/CopyToClipboard";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import ActionableExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import ActionableExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class ActionableExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new ActionableExamplesMoldNotifier(this);
		this.requester = new ActionableExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_1796645908" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_1796645908.a1152032633" format="h6" mode="normal" value="Link">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_1796645908.a_787743677" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_1796645908.a_787743677.a_1047427129" title="operation" target="self" mode="Link" size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_1796645908.a335196205" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_1796645908.a335196205.a_1484521610" mode="normal" language="Html" value="Link(title=&quot;operation&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_1103809184" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_1103809184.a_918222445" format="h6" mode="normal" value="Button">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_1103809184.a_431816442" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_1103809184.a_431816442.a460124681" title="operation" target="self" mode="Button" size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_1103809184.a_270807179" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_1103809184.a_270807179.a_236174449" mode="normal" language="Html" value="Button(title=&quot;operation&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_373360451" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_373360451.a1112508581" format="h6" mode="normal" value="IconButton">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_373360451.a104443175" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_373360451.a104443175.a1967676491" title="operation" target="self" mode="IconButton" size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_373360451.a1037792200" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_373360451.a1037792200.a_1708654068" mode="normal" language="Html" value="IconButton(title=&quot;operation&quot;, icon=&quot;/icons/operation.png&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_1864458104" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_1864458104.a1640049043" format="h6" mode="normal" value="MaterialIconButton">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_1864458104.a1104992143" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_1864458104.a1104992143.a_819738995" title="operation" target="self" mode="MaterialIconButton" icon="Add" size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_1864458104.a_1525407895" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_1864458104.a_1525407895.a1645517420" mode="normal" language="Html" value="MaterialIconButton(title=&quot;operation&quot;,icon=&quot;Add&quot;) as Action&lt;br/&gt;&lt;br/&gt;
							for icons gallery, refer to &lt;a href=&quot;https://material.io/tools/icons&quot; target=&quot;_blank&quot;&gt;material.io&lt;/a&gt;">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a385989998" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a385989998.a_688441946" format="h6" mode="normal" value="Affirmed facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a385989998.a1497918731" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a385989998.a1497918731.a182254190" title="operation" target="self" mode="Button" affirmed="Are you sure you want to execute operation?" size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a385989998.a824552885" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a385989998.a824552885.a1540274840" mode="normal" language="Html" value="Button(title=&quot;operation&quot;) as Action Affirmed(&quot;Are you sure you want to execute operation?&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a169277496" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a169277496.a1026801710" format="h6" mode="normal" value="Highlight attribute">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a169277496.a1711457196" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a169277496.a1711457196.a1689806000" title="operation 1" target="self" mode="Button" size="Medium" highlighted="Outline">
							</UiAction>
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a169277496.a1711457196.a1689806001" title="operation 2" target="self" mode="Button" size="Medium" highlighted="Fill">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a169277496.a399861471" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a169277496.a399861471.a_13659676" mode="normal" language="Html" value="Button(title=&quot;operation 1&quot;, highlight=&quot;Outline&quot;) as Action&lt;br/&gt;
							Button(title=&quot;operation 2&quot;, highlight=&quot;Fill&quot;) as Action&lt;br/&gt;">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_398568056" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_398568056.a_1004171465" format="h6" mode="normal" value="Switch">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_398568056.a143715269" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiActionSwitch context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_398568056.a143715269.a_2108726735" title="edition" target="self" mode="Link" size="Medium" state="Off">
							</UiActionSwitch>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_398568056.a_1526943783" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_398568056.a_1526943783.a1380987540" mode="normal" language="Html" value="Switch(title=&quot;edition&quot;, state=Off) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a703729832" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a703729832.a2114524123" format="h6" mode="normal" value="Signed facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a703729832.a873025348" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a703729832.a873025348.a_601174925" title="edition" target="self" mode="Button" signed={{mode:"SimplePassword",text:"Fill your password before continue",reason:""}} size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a703729832.a1005050968" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a703729832.a1005050968.a193007829" mode="normal" language="Html" value="Button(title=&quot;edition&quot;) as Action Signed(signText=&quot;Fill your password before continue&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a790594655" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a790594655.a_787251692" format="h6" mode="normal" value="Signed facet with reason property">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a790594655.a_1977909395" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a790594655.a_1977909395.a_1967087868" title="edition" target="self" mode="Button" signed={{mode:"SimplePassword",text:"Fill your password before continue",reason:"Fill reason"}} size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a790594655.a1653621533" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a790594655.a1653621533.a1072940120" mode="normal" language="Html" value="Button(title=&quot;edition&quot;) as Action Signed(signText=&quot;Fill your password before continue&quot;, reasonText=&quot;Fill reason&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_200155702" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_200155702.a_133017550" format="h6" mode="normal" value="Toggle">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_200155702.a_180331829" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiActionToggle context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_200155702.a_180331829.a_131014943" title="edition" target="self" mode="Toggle" size="Medium" state="Off">
							</UiActionToggle>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_200155702.a_442215969" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_200155702.a_442215969.a231625982" mode="normal" language="Html" value="Toggle(title=&quot;edition&quot;, state=Off) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a1511633060" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a1511633060.a_953551689" format="h6" mode="normal" value="IconToggle">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a1511633060.a_1585862428" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiActionToggle context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a1511633060.a_1585862428.a_641549118" title="operation" target="self" mode="IconToggle" size="Medium" state="Off">
							</UiActionToggle>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a1511633060.a_1569790036" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a1511633060.a_1569790036.a_353768199" mode="normal" language="Html" value="IconToggle(title=&quot;operation&quot;, icon=&quot;/icons/operation.png&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a1469619235" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a1469619235.a713748142" format="h6" mode="normal" value="MaterialIconToggle">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a1469619235.a_1404029559" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiActionToggle context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a1469619235.a_1404029559.a_1152083296" title="edition" target="self" mode="MaterialIconToggle" icon="FilterList" size="Medium" state="On">
							</UiActionToggle>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a1469619235.a_724670509" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a1469619235.a_724670509.a_1442140384" mode="normal" language="Html" value="MaterialIconToggle(title=&quot;edition&quot;, state=On, icon=&quot;FilterList&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_823464229" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_823464229.a2025511615" format="h6" mode="normal" value="SplitButton">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_823464229.a_2003646067" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiActionSplit context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_823464229.a_2003646067.a_1662617471" title="edition" target="self" mode="SplitButton" size="Medium" options={["option 1","option 2"]} defaultOption="option 1">
							</UiActionSplit>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_823464229.a244537257" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_823464229.a244537257.a903581240" mode="normal" language="Html" value="SplitButton(title=&quot;edition&quot;, options=&quot;option 1&quot; &quot;option 2&quot;, defaultOption=&quot;option 1&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_824858515" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_824858515.a_1264422532" format="h6" mode="normal" value="MaterialIconSplitButton">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_824858515.a_302756367" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiActionSplit context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_824858515.a_302756367.a2121815649" title="edition" target="self" mode="MaterialIconSplitButton" icon="Add" size="Medium" options={["option 1","option 2"]} defaultOption="option 1" icon="Add">
							</UiActionSplit>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_824858515.a1340009256" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_824858515.a1340009256.a_1584484735" mode="normal" language="Html" value="MaterialIconSplitButton(title=&quot;edition&quot;, icon=&quot;Add&quot;, options=&quot;option 1&quot; &quot;option 2&quot;, defaultOption=&quot;option 1&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_412353902" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_412353902.a_833452148" format="h6" mode="normal" value="AvatarIconButton">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_412353902.a_1179339965" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_412353902.a_1179339965.a1611281473" title="I am avatar" target="self" mode="AvatarIconButton" size="Medium" highlighted="Fill">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_412353902.a_359771061" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_412353902.a_359771061.a_282247211" mode="normal" language="Html" value="AvatarIconButton(title=&quot;I am avatar&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_805226281" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_805226281.a1472663520" format="h6" mode="normal" value="CopyToClipboard">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_805226281.a_355656764" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiCopyToClipboard context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_805226281.a_355656764.a1100747297" title="Copy to clipboard" target="self" mode="Link" size="Medium">
							</UiCopyToClipboard>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_805226281.a_1631230435" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_805226281.a_1631230435.a_696289025" mode="normal" language="Html" value="Link(title=&quot;Copy to clipboard&quot;, text=&quot;I am text&quot;) as CopyToClipboard(text=&quot;I am text&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_1881102371" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_1881102371.a_916871442" format="h6" mode="normal" value="OneTimePassword">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_1881102371.a684076717" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_1881102371.a684076717.a590213121" title="One time password" target="self" mode="Link" signed={{mode:"OneTimePassword",text:"Password required",reason:""}} size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_1881102371.a_1091308930" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1039798572.a_1881102371.a_1091308930.a89245504" mode="normal" language="Html" value="Link(title=&quot;One time password&quot;) as Action Signed(signText=&quot;Password required&quot;, mode=OneTimePassword)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(ActionableExamplesMold));
DisplayFactory.register("ActionableExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(ActionableExamplesMold)));