import Requester from "./Requester";

export default class UserRequester extends Requester {
	constructor(element) {
		super(element);
	};
	logout = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "logout", s: "user", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	refreshChildren = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "refreshChildren", s: "user", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	didMount = () => {
		this.pushService.send({ op: "didMount", s: "user", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
}