import Requester from "./Requester";

export default class DateNavigatorRequester extends Requester {
	constructor(element) {
		super(element);
	};
	first = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "first", s: "datenavigator", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	previous = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "previous", s: "datenavigator", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	next = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "next", s: "datenavigator", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	last = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "last", s: "datenavigator", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	select = (value) => {
		if (this.addToHistory(value)) return;
		this.pushService.send({ app: this.element.context, op: "select", s: "datenavigator", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
	changeScale = (value) => {
		if (this.addToHistory(value)) return;
		this.pushService.send({ app: this.element.context, op: "changeScale", s: "datenavigator", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
	didMount = () => {
		this.pushService.send({ op: "didMount", s: "datenavigator", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
}