import Notifier from "alexandria-ui-elements/src/displays/notifiers/ComponentNotifier";

export default class KpiNotifier extends Notifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("refresh").toSelf().execute((parameters) => this.element.refresh(parameters.v));
		this.when("refreshLabel").toSelf().execute((parameters) => this.element.refreshLabel(parameters.v));
		this.when("refreshColors").toSelf().execute((parameters) => this.element.refreshColors(parameters.v));
		this.when("refreshHighlighted").toSelf().execute((parameters) => this.element.refreshHighlighted(parameters.v));
		this.pushLinked = true;
	};
}