import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTimeline from "alexandria-ui-elements/src/displays/components/Timeline";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import TimelineExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import TimelineExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class TimelineExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new TimelineExamplesMoldNotifier(this);
		this.requester = new TimelineExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1349993157" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1349993157.a_537066927" format="autoHeight" layout="vertical" width="100.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1349993157.a_537066927.a62484108" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1349993157.a_537066927.a_360824572" format="filledNoAirExtraLarge" layout="vertical">
							<UiTimeline context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1349993157.a_537066927.a_360824572.a_882196350" mode="Summary">
							</UiTimeline>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1349993157.a_537066927.a_360824572.a_721894461" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1349993157.a_537066927.a_360824572.a_721894461.a529632987" mode="normal" language="Html" value="Timeline">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1349993157.a_506099754" layout="vertical" width="100.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1349993157.a_506099754.a524962399" format="h6" mode="normal" value="No facets (Catalog mode)">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1349993157.a_506099754.a_200556400" format="filledNoAirExtraLarge" layout="vertical" width="-1px" height="500px">
							<UiTimeline context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1349993157.a_506099754.a_200556400.a_1387754974" mode="Catalog">
							</UiTimeline>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1349993157.a_506099754.a_200556400.a_1857725703" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1349993157.a_506099754.a_200556400.a_1857725703.a1834158106" mode="normal" language="Html" value="Timeline(mode=Catalog)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(TimelineExamplesMold));
DisplayFactory.register("TimelineExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(TimelineExamplesMold)));