import { createTheme } from '@material-ui/core/styles';

const Theme = (function () {
	var theme = null;
	var provider = {
		create: () => {
			theme = createTheme({
				palette : {
					primary : { main: "#3f51b5" },
					secondary : { main: "#ff9100" },
					error : { main: "#f44336" },
					contrastThreshold : "3",
					tonalOffset : "0.2",
					grey : {
						primary: "#888",
						secondary: '#ddd'
					}
				},
				typography : {
					fontFamily : '"-apple-system","BlinkMacSystemFont","Segoe UI","Roboto","Helvetica Neue","Arial","sans-serif","Apple Color Emoji","Segoe UI Emoji","Segoe UI Symbol"',
					fontSize : 13,
					useNextVariants: true
				},
				formats: {
					h1: { color:'#B71C1C',textShadow:'2px 2px 2px #fff' },
					h2: { color:'black',textShadow:'2px 2px 2px #fff' },
					h3: {  },
					h4: {  },
					h5: {  },
					h6: { lineHeight:'17pt' },
					body1: {  },
					body2: {  },
					subtitle1: {  },
					subtitle2: {  },
					white: { color:'white' },
					higgerFont: { fontSize:'50pt' },
					whiteBackground: { background:'white',borderRadius:'3px',height:'100%' },
					air: { padding:'10px 20px' },
					airTop: { marginTop:'10px' },
					airBottom: { marginBottom:'10px' },
					doubleAirBottom: { marginBottom:'20px' },
					airLeft: { marginRight:'10px' },
					airRight: { marginRight:'10px' },
					bold: { fontWeight:'bold' },
					containerAirMedium: { padding:'10px' },
					containerAirLarge: { padding:'20px' },
					filled: { background:'#efefef',padding:'8px',minHeight:'200px' },
					filledNoAir: { background:'#efefef',minHeight:'200px' },
					filledNoAirLarge: { background:'#efefef',minHeight:'400px' },
					filledNoAirExtraLarge: { background:'#efefef',minHeight:'670px' },
					autoHeight: { overflow:'auto',height:'200px' },
					autoOverflow: { overflow:'auto' },
					extraHeight: { height:'400px' },
					verticalExtraHeight: { height:'900px' },
					headerToolbar: { marginTop:'10px' },
					textCentered: { textAlign:'center' },
					facetsAbsolute: { color:'#888',fontSize:'10px' },
					valuesLabelFormat: { whiteSpace:'nowrap' },
					bordered: { border:'1px solid',width:'100%' },
					bottomBordered: { borderBottom:'1px solid' },
					topBordered: { borderTop:'1px solid' },
					paperFormat: { minHeight:'300px' },
					underline: { borderBottom:'1px dotted #ddd',width:'100%',marginBottom:'10px' },
					description: { fontSize:'10pt',color:'grey' },
					minTableHeight: { minHeight:'200px' },
					redColor: { color:'red' },
					cardTitle: { textAlign:'left',color:'#B71A1C',padding:'10px' },
					cardContent: { textAlign:'left',padding:'10px' },
					widgetType: { color:'#888' },
					widgetDemo: { margin:'0 0 5px 0' }
				}
			});
			return theme;
		},
		get: () => {
			return theme;
		},
	};
	return provider;
})();

export default Theme;