import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTable from "alexandria-ui-elements/src/displays/components/Table";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiHeading from "alexandria-ui-elements/src/displays/components/Heading";
import UiSelectPreviousItem from "alexandria-ui-elements/src/displays/components/SelectPreviousItem";
import UiSelectNextItem from "alexandria-ui-elements/src/displays/components/SelectNextItem";
import DisplaysTable1Row from "ui-elements/gen/displays/rows/Table1Row";
import DisplaysTable11Mold from "ui-elements/gen/displays/items/Table11Mold";
import DisplaysTable12Mold from "ui-elements/gen/displays/items/Table12Mold";
import DisplaysTable2Row from "ui-elements/gen/displays/rows/Table2Row";
import DisplaysTable21Mold from "ui-elements/gen/displays/items/Table21Mold";
import DisplaysTable22Mold from "ui-elements/gen/displays/items/Table22Mold";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import TableExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import TableExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class TableExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new TableExamplesMoldNotifier(this);
		this.requester = new TableExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1002820975" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1002820975.a1179763358" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1002820975.a1179763358.a_1156455586" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1002820975.a1179763358.a_996644590" format="filledNoAir" layout="vertical" spacing="8">
							<UiTable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1002820975.a1179763358.a_996644590.a_97726499" pageSize={20} itemHeight={60} scrollingMark={true}>
							</UiTable>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1002820975.a1179763358.a879119203" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1002820975.a1179763358.a879119203.a_101220224" mode="normal" language="Html" value="Table(itemClass=&quot;io.intino.alexandria.ui.documentation.Person&quot;) table&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold &gt; Item(height=60px,width=30%) table1Mold &gt; Text firstName as Editable&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold &gt; Item(height=60px,width=70%) table2Mold &gt; Text lastName as Editable">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1002820975.a477003694" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1002820975.a477003694.a_1343444854" format="h6" mode="normal" value="No facets with heading">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1002820975.a477003694.a1257368310" format="filledNoAir" layout="vertical" spacing="8">
							<UiTable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1002820975.a477003694.a1257368310.a_969199731" pageSize={20} itemHeight={60} scrollingMark={true} selection="single">
								<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1002820975.a477003694.a1257368310.a_969199731.a1505620314" style={{width:"30%",paddingRight:"10px",paddingLeft:"10px"}} hidden="Never">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1002820975.a477003694.a1257368310.a_969199731.a1505620314.a_2083615634" mode="normal" value="first name">
									</UiText>
								</UiHeading>
								<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1002820975.a477003694.a1257368310.a_969199731.a39336710" style={{width:"70%",paddingRight:"10px"}} hidden="Never">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1002820975.a477003694.a1257368310.a_969199731.a39336710.a_1504647719" mode="normal" value="last name">
									</UiText>
								</UiHeading>
							</UiTable>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1002820975.a477003694.a86000716" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1002820975.a477003694.a86000716.a_320826487" mode="normal" language="Html" value="Table(itemClass=&quot;io.intino.alexandria.ui.documentation.Person&quot;) table&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Heading firstNameHeading &gt; Text(value=&quot;first name&quot;)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Item(height=60px,width=30%) table21Mold &gt; Text firstName&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Heading lastNameHeading &gt; Text(value=&quot;last name&quot;)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Item(height=60px,width=70%) table22Mold &gt; Text lastName">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1002820975.a1574619138" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1002820975.a1574619138.a739211985" format="h6" mode="normal" value="Selectable collection buttons">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1002820975.a1574619138.a1140986857" format="filledNoAir" layout="horizontal centercenter flexible" spacing="8">
							<UiSelectPreviousItem context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1002820975.a1574619138.a1140986857.a90094062" title="Previous" target="self" mode="MaterialIconButton" icon="KeyboardArrowLeft" size="Medium" format="airRight">
							</UiSelectPreviousItem>
							<UiSelectNextItem context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1002820975.a1574619138.a1140986857.a1892326762" title="Next" target="self" mode="MaterialIconButton" icon="KeyboardArrowRight" size="Medium">
							</UiSelectNextItem>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1002820975.a1574619138.a1734836979" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1002820975.a1574619138.a1734836979.a1957157082" mode="normal" language="Html" value="Table(itemClass=&quot;io.intino.alexandria.ui.documentation.Person&quot;) table&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Heading firstNameHeading &gt; Text(value=&quot;first name&quot;)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Item(height=60px,width=30%) table21Mold &gt; Text firstName&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Heading lastNameHeading &gt; Text(value=&quot;last name&quot;)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Item(height=60px,width=70%) table22Mold &gt; Text lastName">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(TableExamplesMold));
DisplayFactory.register("TableExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(TableExamplesMold)));