import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiEventline from "alexandria-ui-elements/src/displays/components/Eventline";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import EventlineExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import EventlineExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class EventlineExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new EventlineExamplesMoldNotifier(this);
		this.requester = new EventlineExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_923989182" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_923989182.a_950466469" format="extraHeight" layout="vertical" width="100.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_923989182.a_950466469.a_43085031" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_923989182.a_950466469.a_967985404" format="air filledNoAirExtraLarge" layout="vertical">
							<UiEventline context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_923989182.a_950466469.a_967985404.a_1209638594" arrangement="Horizontal">
							</UiEventline>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_923989182.a_950466469.a_967985404.a_1596283531" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_923989182.a_950466469.a_967985404.a_1596283531.a383752615" mode="normal" language="Html" value="Eventline">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_923989182.a1995746750" layout="vertical" width="100.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_923989182.a1995746750.a560345690" format="h6" mode="normal" value="No facets (Vertical arrangement)">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_923989182.a1995746750.a48892990" format="air filledNoAirLarge" layout="vertical">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_923989182.a1995746750.a48892990.a663877762" layout="vertical" width="-1px" height="400px">
								<UiEventline context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_923989182.a1995746750.a48892990.a663877762.a_78562690" arrangement="Vertical">
								</UiEventline>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_923989182.a1995746750.a48892990.a_1048215958" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_923989182.a1995746750.a48892990.a_1048215958.a1471305772" mode="normal" language="Html" value="Eventline(arrangement=Vertical)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(EventlineExamplesMold));
DisplayFactory.register("EventlineExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(EventlineExamplesMold)));