import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiSignText from "alexandria-ui-elements/src/displays/components/SignText";
import UiSignDocument from "alexandria-ui-elements/src/displays/components/SignDocument";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import DigitalSignatureExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import DigitalSignatureExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class DigitalSignatureExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new DigitalSignatureExamplesMoldNotifier(this);
		this.requester = new DigitalSignatureExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a527190633" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a527190633.a1644008375" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a527190633.a1644008375.a_2050171324" format="h6" mode="normal" value="Sign by using @firma">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a527190633.a1644008375.a_393998016" format="filledNoAir" layout="vertical centercenter">
							<UiSignText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a527190633.a1644008375.a_393998016.a1343638070" title="Sign text" target="self" mode="Link" size="Medium" format="airBottom" signFormat="XAdES">
							</UiSignText>
							<UiSignDocument context={this._context.bind(this)} owner={this._owner.bind(this)} id="a527190633.a1644008375.a_393998016.a_634312284" title="Sign document" target="self" mode="Link" size="Medium">
							</UiSignDocument>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a527190633.a1644008375.a_393998016.a_743265069" format="airTop" layout="vertical">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a527190633.a1644008375.a_393998016.a_743265069.a39960913" label="Signature" mode="normal" cropWithEllipsis={40}>
								</UiText>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a527190633.a1644008375.a_393998016.a137625167" format="airTop" layout="vertical">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a527190633.a1644008375.a_393998016.a137625167.a1793041977" label="Signed by" mode="normal" cropWithEllipsis={40}>
								</UiText>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a527190633.a1644008375.a_393998016.a1544606491" format="airTop" layout="vertical">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a527190633.a1644008375.a_393998016.a1544606491.a499649827" label="Error" format="redColor" mode="normal">
								</UiText>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a527190633.a1644008375.a1481559819" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a527190633.a1644008375.a1481559819.a526005114" mode="normal" language="Html" value="Link(title=&quot;Sign text&quot;) as SignText&lt;br/&gt;
							Link(title=&quot;Sign document&quot;) as SignDocument">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(DigitalSignatureExamplesMold));
DisplayFactory.register("DigitalSignatureExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(DigitalSignatureExamplesMold)));