import BaseSelectorRequester from "./BaseSelectorRequester"

export default class SelectorListBoxRequester extends BaseSelectorRequester {
	constructor(element) {
		super(element);
	};
	updateSelection = (value) => {
		if (this.addToHistory(value)) return;
		this.pushService.send({ app: this.element.context, op: "updateSelection", s: "selectorlistbox", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(JSON.stringify(value))}, this.element.ownerUnit());
	};
	didMount = () => {
		this.pushService.send({ op: "didMount", s: "selectorlistbox", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
}