import Notifier from "alexandria-ui-elements/src/displays/notifiers/ComponentNotifier";

export default class TimelineNotifier extends Notifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("setup").toSelf().execute((parameters) => this.element.setup(parameters.v));
		this.when("refreshHistory").toSelf().execute((parameters) => this.element.refreshHistory(parameters.v));
		this.when("refreshHistoryToolbar").toSelf().execute((parameters) => this.element.refreshHistoryToolbar(parameters.v));
		this.when("refreshMagnitudesVisibility").toSelf().execute((parameters) => this.element.refreshMagnitudesVisibility(parameters.v));
		this.when("refreshMagnitudesSorting").toSelf().execute((parameters) => this.element.refreshMagnitudesSorting(parameters.v));
		this.when("refreshMagnitudes").toSelf().execute((parameters) => this.element.refreshMagnitudes(parameters.v));
		this.when("showHistoryDialog").toSelf().execute((parameters) => this.element.showHistoryDialog(parameters.v));
		this.pushLinked = true;
	};
}