import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTimeline from "alexandria-ui-elements/src/displays/components/Timeline";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import TimelineExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import TimelineExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class TimelineExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new TimelineExamplesMoldNotifier(this);
		this.requester = new TimelineExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_495579597" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_495579597.a874487494" format="autoHeight" layout="vertical" width="100.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_495579597.a874487494.a62484108" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_495579597.a874487494.a_1584911156" format="filledNoAirExtraLarge" layout="vertical">
							<UiTimeline context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_495579597.a874487494.a_1584911156.a_882196350" mode="Summary">
							</UiTimeline>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_495579597.a874487494.a_1584911156.a_1044433612" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_495579597.a874487494.a_1584911156.a_1044433612.a_631025148" mode="normal" language="Html" value="Timeline">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1787313425" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1787313425.a_1504569591" layout="vertical" width="100.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1787313425.a_1504569591.a_457285258" format="h6" mode="normal" value="No facets (Catalog mode)">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1787313425.a_1504569591.a1518346322" format="filledNoAirExtraLarge" layout="vertical" width="-1px" height="500px">
							<UiTimeline context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1787313425.a_1504569591.a1518346322.a_1681157981" mode="Catalog">
							</UiTimeline>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1787313425.a_1504569591.a1518346322.a1299366715" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1787313425.a_1504569591.a1518346322.a1299366715.a_714432360" mode="normal" language="Html" value="Timeline(mode=Catalog)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(TimelineExamplesMold));
DisplayFactory.register("TimelineExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(TimelineExamplesMold)));