import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiHeader from "alexandria-ui-elements/src/displays/components/Header";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiImage from "alexandria-ui-elements/src/displays/components/Image";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiOpenPage from "alexandria-ui-elements/src/displays/components/OpenPage";
import UiBlockParallax from "alexandria-ui-elements/src/displays/components/BlockParallax";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import HomeTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import HomeTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class HomeTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new HomeTemplateNotifier(this);
		this.requester = new HomeTemplateRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" style={{...this.props.style,...display}}>
				<UiHeader context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1503651646" format="air" color="white" position="relative" width="-1px" height="100px" elevation={4}>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1503651646.a1017750626" layout="horizontal center" spacing="24">
						<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1503651646.a1017750626.a_1156303512" width="80px" height="80px">
						</UiImage>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1503651646.a1017750626.a355485468" format="h3" mode="normal" value="intino">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1503651646.a1017750626.a_1178122886" format="headerToolbar" layout="horizontal center" spacing="24">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1503651646.a1017750626.a_1178122886.a_2061316628" mode="normal" value="home">
							</UiText>
							<UiOpenPage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1503651646.a1017750626.a_1178122886.a517706267" title="widgets" target="self" mode="Link" size="Medium">
							</UiOpenPage>
						</UiBlock>
					</UiBlock>
				</UiHeader>
				<UiBlockParallax context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2108101988" format="containerAirLarge" layout="vertical" width="-1px" height="500px">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2108101988.a_1492878551" layout="vertical center" width="70.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2108101988.a_1492878551.a864912435" format="h1 textCentered" mode="normal" value="software production lines made easy">
						</UiText>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2108101988.a_1492878551.a_1435380596" format="h2" mode="normal" value="symplifying software mass customization">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2108101988.a_1492878551.a882124676" layout="horizontal">
						</UiBlock>
					</UiBlock>
				</UiBlockParallax>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_713870915" format="containerAirLarge" layout="vertical">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_713870915.a750766049" layout="vertical center" width="70.0%" height="100.0%" spacing="40">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_713870915.a750766049.a1952227401" layout="vertical">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_713870915.a750766049.a1952227401.a_853597972" format="air h1" mode="normal" value="Why intino?">
							</UiText>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_713870915.a750766049.a1316951054" layout="horizontal centercenter" width="-1px" height="300px" spacing="40">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_713870915.a750766049.a1316951054.a_583875016" layout="vertical" width="28.0%" height="100.0%" paper>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_713870915.a750766049.a1316951054.a_583875016.a_1735088148" format="cardTitle h5" mode="normal" value="flexibility">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_713870915.a750766049.a1316951054.a_583875016.a106018608" format="cardContent h5" mode="normal" value="Extending benefits beyond software development into modifiability. With intino, software evolution is tailor-made, that is evolving systems built specifically for the needs of particular customer">
								</UiText>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_713870915.a750766049.a1316951054.a1110840208" layout="vertical" width="28.0%" height="100.0%" paper>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_713870915.a750766049.a1316951054.a1110840208.a_1774859665" format="cardTitle h5" mode="normal" value="reuse">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_713870915.a750766049.a1316951054.a1110840208.a_773164803" format="cardContent h5" mode="normal" value="Developing core components that can be reused. This is the strategy that creates an opportunity for benefits in reducing the effort and costs costs required to create, deploy and software">
								</UiText>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_713870915.a750766049.a1316951054.a1886235030" layout="vertical" width="28.0%" height="100.0%" paper>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_713870915.a750766049.a1316951054.a1886235030.a_279012106" format="cardTitle h5" mode="normal" value="quality">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_713870915.a750766049.a1316951054.a1886235030.a969419725" format="cardContent h5" mode="normal" value="Lowering the complexity of product line development. Application developers can focus on user requirements, getting advantage on the platform architecture that provides a stable quality">
								</UiText>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlockParallax context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1471791824" format="containerAirLarge" layout="vertical" width="-1px" height="500px">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1471791824.a_471030384" layout="vertical center" width="70.0%" height="100.0%" spacing="40">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1471791824.a_471030384.a_2026659049" layout="vertical">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1471791824.a_471030384.a_2026659049.a_567821330" format="air h2 white" mode="normal" value="What does it look like?">
							</UiText>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1471791824.a_471030384.a969926512" layout="horizontal">
						</UiBlock>
					</UiBlock>
				</UiBlockParallax>
				<UiBlockParallax context={this._context.bind(this)} owner={this._owner.bind(this)} id="a944301390" format="containerAirLarge" layout="vertical" width="-1px" height="500px">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a944301390.a_1574499213" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a944301390.a_1574499213.a1594544153" format="h1" mode="normal" value="software production lines made easy">
						</UiText>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a944301390.a_1574499213.a340743124" format="h2" mode="normal" value="symplifying software mass customization">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a944301390.a_1574499213.a_1636718900" layout="horizontal">
						</UiBlock>
					</UiBlock>
				</UiBlockParallax>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(HomeTemplate));
DisplayFactory.register("HomeTemplate", withStyles(styles, { withTheme: true })(withSnackbar(HomeTemplate)));