import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiDisplayStamp from "alexandria-ui-elements/src/displays/components/DisplayStamp";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiMultiple from "alexandria-ui-elements/src/displays/components/Multiple";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiBlockConditional from "alexandria-ui-elements/src/displays/components/BlockConditional";
import DisplaysTextExamplesMold from "ui-elements/gen/displays/templates/TextExamplesMold";
import DisplaysNumberExamplesMold from "ui-elements/gen/displays/templates/NumberExamplesMold";
import DisplaysFileExamplesMold from "ui-elements/gen/displays/templates/FileExamplesMold";
import DisplaysImageExamplesMold from "ui-elements/gen/displays/templates/ImageExamplesMold";
import DisplaysDateExamplesMold from "ui-elements/gen/displays/templates/DateExamplesMold";
import DisplaysMultipleExamplesMold from "ui-elements/gen/displays/templates/MultipleExamplesMold";
import DisplaysChartExamplesMold from "ui-elements/gen/displays/templates/ChartExamplesMold";
import DisplaysBlockExamplesMold from "ui-elements/gen/displays/templates/BlockExamplesMold";
import DisplaysListExamplesMold from "ui-elements/gen/displays/templates/ListExamplesMold";
import DisplaysTableExamplesMold from "ui-elements/gen/displays/templates/TableExamplesMold";
import DisplaysDynamicTableExamplesMold from "ui-elements/gen/displays/templates/DynamicTableExamplesMold";
import DisplaysGridExamplesMold from "ui-elements/gen/displays/templates/GridExamplesMold";
import DisplaysMapExamplesMold from "ui-elements/gen/displays/templates/MapExamplesMold";
import DisplaysDownloadExamplesMold from "ui-elements/gen/displays/templates/DownloadExamplesMold";
import DisplaysDownloadSelectionExamplesMold from "ui-elements/gen/displays/templates/DownloadSelectionExamplesMold";
import DisplaysExportExamplesMold from "ui-elements/gen/displays/templates/ExportExamplesMold";
import DisplaysActionableExamplesMold from "ui-elements/gen/displays/templates/ActionableExamplesMold";
import DisplaysGroupingExamplesMold from "ui-elements/gen/displays/templates/GroupingExamplesMold";
import DisplaysGroupingToolbarExamplesMold from "ui-elements/gen/displays/templates/GroupingToolbarExamplesMold";
import DisplaysSortingExamplesMold from "ui-elements/gen/displays/templates/SortingExamplesMold";
import DisplaysSearchBoxExamplesMold from "ui-elements/gen/displays/templates/SearchBoxExamplesMold";
import DisplaysSliderExamplesMold from "ui-elements/gen/displays/templates/SliderExamplesMold";
import DisplaysDashboardExamplesMold from "ui-elements/gen/displays/templates/DashboardExamplesMold";
import DisplaysAppDirectoryExamplesMold from "ui-elements/gen/displays/templates/AppDirectoryExamplesMold";
import DisplaysDigitalSignatureExamplesMold from "ui-elements/gen/displays/templates/DigitalSignatureExamplesMold";
import DisplaysDialogExamplesMold from "ui-elements/gen/displays/templates/DialogExamplesMold";
import DisplaysLayerExamplesMold from "ui-elements/gen/displays/templates/LayerExamplesMold";
import DisplaysDividerExamplesMold from "ui-elements/gen/displays/templates/DividerExamplesMold";
import DisplaysUserExamplesMold from "ui-elements/gen/displays/templates/UserExamplesMold";
import DisplaysLocationExamplesMold from "ui-elements/gen/displays/templates/LocationExamplesMold";
import DisplaysSelectorExamplesMold from "ui-elements/gen/displays/templates/SelectorExamplesMold";
import DisplaysStepperExamplesMold from "ui-elements/gen/displays/templates/StepperExamplesMold";
import DisplaysFrameExamplesMold from "ui-elements/gen/displays/templates/FrameExamplesMold";
import DisplaysMicroSiteExamplesMold from "ui-elements/gen/displays/templates/MicroSiteExamplesMold";
import DisplaysHtmlViewerExamplesMold from "ui-elements/gen/displays/templates/HtmlViewerExamplesMold";
import DisplaysTimelineExamplesMold from "ui-elements/gen/displays/templates/TimelineExamplesMold";
import DisplaysEventlineExamplesMold from "ui-elements/gen/displays/templates/EventlineExamplesMold";
import DisplaysReelExamplesMold from "ui-elements/gen/displays/templates/ReelExamplesMold";
import DisplaysPropertyMold from "ui-elements/gen/displays/templates/PropertyMold";
import DisplaysMethodMold from "ui-elements/gen/displays/templates/MethodMold";
import DisplaysEventsDisplay from "ui-elements/src/displays/EventsDisplay";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import WidgetMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import WidgetMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class WidgetMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new WidgetMoldNotifier(this);
		this.requester = new WidgetMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return this.renderDynamicLoaded(
			<UiBlock layout="vertical" style={{...this.props.style,...display}}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1078556726" format="h3" mode="normal" value="Widget">
				</UiText>
				<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_133628978" format="body1" multiple={{instances:"highlightFacets",arrangement:"Horizontal",noItemsMessage:"",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}} mode="normal" highlighted={{text:"white",background:"#679164"}}>
				</UiMultiple>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1216248666" format="airBottom body1" mode="normal">
				</UiText>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249" layout="vertical" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a991727366" format="h5 underline" mode="normal" value="Examples">
						</UiText>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_1552201153" layout="vertical">
							<DisplaysTextExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_1552201153.a1260852525">
							</DisplaysTextExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a1634352667" layout="vertical">
							<DisplaysNumberExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a1634352667.a_1508260301">
							</DisplaysNumberExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a1742945166" layout="vertical">
							<DisplaysFileExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a1742945166.a_1889788143">
							</DisplaysFileExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_2075012549" layout="vertical">
							<DisplaysImageExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_2075012549.a272132976">
							</DisplaysImageExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a1403380672" layout="vertical">
							<DisplaysDateExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a1403380672.a_551836582">
							</DisplaysDateExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_1401873502" layout="vertical">
							<DisplaysMultipleExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_1401873502.a_2087766999">
							</DisplaysMultipleExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_168702530" layout="vertical">
							<DisplaysChartExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_168702530.a1777898827">
							</DisplaysChartExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_1006527635" layout="vertical">
							<DisplaysBlockExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_1006527635.a_1162748428">
							</DisplaysBlockExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_200166224" layout="vertical">
							<DisplaysListExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_200166224.a_1606082113">
							</DisplaysListExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_1041022546" layout="vertical">
							<DisplaysTableExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_1041022546.a1159943251">
							</DisplaysTableExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a1668269281" layout="vertical">
							<DisplaysDynamicTableExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a1668269281.a_1420870958">
							</DisplaysDynamicTableExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a981362520" layout="vertical">
							<DisplaysGridExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a981362520.a1328208517">
							</DisplaysGridExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_239751428" layout="vertical">
							<DisplaysMapExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_239751428.a_1501876165">
							</DisplaysMapExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a795166234" layout="vertical">
							<DisplaysDownloadExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a795166234.a_958952116">
							</DisplaysDownloadExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a2141648708" layout="vertical">
							<DisplaysDownloadSelectionExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a2141648708.a156125911">
							</DisplaysDownloadSelectionExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a1931271046" layout="vertical">
							<DisplaysExportExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a1931271046.a_523890835">
							</DisplaysExportExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a44586978" layout="vertical">
							<DisplaysActionableExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a44586978.a_1708204508">
							</DisplaysActionableExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a507932565" layout="vertical">
							<DisplaysGroupingExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a507932565.a_1246146610">
							</DisplaysGroupingExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_2029649896" layout="vertical">
							<DisplaysGroupingToolbarExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_2029649896.a500024773">
							</DisplaysGroupingToolbarExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_1565178972" layout="vertical">
							<DisplaysSortingExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_1565178972.a1839616371">
							</DisplaysSortingExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_655143837" layout="vertical">
							<DisplaysSearchBoxExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_655143837.a538908418">
							</DisplaysSearchBoxExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a1931920307" layout="vertical">
							<DisplaysSliderExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a1931920307.a380340890">
							</DisplaysSliderExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_1375127820" layout="vertical">
							<DisplaysDashboardExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_1375127820.a_1557846554">
							</DisplaysDashboardExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_1473751458" layout="vertical">
							<DisplaysAppDirectoryExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_1473751458.a564981144">
							</DisplaysAppDirectoryExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_1725959662" layout="vertical">
							<DisplaysDigitalSignatureExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_1725959662.a_94286267">
							</DisplaysDigitalSignatureExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a19198234" layout="vertical">
							<DisplaysDialogExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a19198234.a1369616504">
							</DisplaysDialogExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_2015451087" layout="vertical">
							<DisplaysLayerExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_2015451087.a1469085198">
							</DisplaysLayerExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a1492491321" layout="vertical">
							<DisplaysDividerExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a1492491321.a1226266440">
							</DisplaysDividerExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_2051902755" layout="vertical">
							<DisplaysUserExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_2051902755.a_1875737462">
							</DisplaysUserExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a1624940615" layout="vertical">
							<DisplaysLocationExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a1624940615.a1246034027">
							</DisplaysLocationExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_399037839" layout="vertical">
							<DisplaysSelectorExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_399037839.a_1396611388">
							</DisplaysSelectorExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_1422329871" layout="vertical">
							<DisplaysStepperExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_1422329871.a_1364628425">
							</DisplaysStepperExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_1728470963" layout="vertical">
							<DisplaysFrameExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_1728470963.a_1151511232">
							</DisplaysFrameExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a783963531" layout="vertical">
							<DisplaysMicroSiteExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a783963531.a_1834187110">
							</DisplaysMicroSiteExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a407596015" layout="vertical">
							<DisplaysHtmlViewerExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a407596015.a837500688">
							</DisplaysHtmlViewerExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a1992067283" layout="vertical">
							<DisplaysTimelineExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a1992067283.a_179850928">
							</DisplaysTimelineExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_113051666" layout="vertical">
							<DisplaysEventlineExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_113051666.a_1841781344">
							</DisplaysEventlineExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_796843476" layout="vertical">
							<DisplaysReelExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a2088208374.a_796843476.a_510381200">
							</DisplaysReelExamplesMold>
						</UiBlockConditional>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a295646345" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a295646345.a1483489740" format="h5 underline" mode="normal" value="Facets">
						</UiText>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a295646345.a_1379543978" mode="normal">
						</UiText>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a1152439593" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a1152439593.a_289107076" format="h5 underline" mode="normal" value="Properties">
						</UiText>
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a1152439593.a_595490263" multiple={{instances:"properties",arrangement:"Vertical",noItemsMessage:"no properties",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
						</UiMultiple>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a_676019558" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a_676019558.a994009947" format="h5 underline" mode="normal" value="Methods">
						</UiText>
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a_676019558.a759855807" multiple={{instances:"methods",arrangement:"Vertical",noItemsMessage:"no methods",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
						</UiMultiple>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a1557646079" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a1557646079.a_580933758" format="h5 underline" mode="normal" value="Events">
						</UiText>
						<UiDisplayStamp context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1227167249.a1557646079.a_319366577">
						</UiDisplayStamp>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(WidgetMold));
DisplayFactory.register("WidgetMold", withStyles(styles, { withTheme: true })(withSnackbar(WidgetMold)));