import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiStepper from "alexandria-ui-elements/src/displays/components/Stepper";
import UiStep from "alexandria-ui-elements/src/displays/components/Step";
import UiImage from "alexandria-ui-elements/src/displays/components/Image";
import UiDate from "alexandria-ui-elements/src/displays/components/Date";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import StepperExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import StepperExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class StepperExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new StepperExamplesMoldNotifier(this);
		this.requester = new StepperExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a531198060" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a531198060.a1132618956" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a531198060.a1132618956.a_7394084" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a531198060.a1132618956.a_969467805" format="filledNoAirExtraLarge" layout="vertical">
							<UiStepper context={this._context.bind(this)} owner={this._owner.bind(this)} id="a531198060.a1132618956.a_969467805.a_1420588258" style="Full"    orientation="horizontal" position="bottom">
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a531198060.a1132618956.a_969467805.a_1420588258.a2128704132" label="Step1">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a531198060.a1132618956.a_969467805.a_1420588258.a2128704132.a1505434230" mode="normal" value="hola1">
									</UiText>
								</UiStep>
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a531198060.a1132618956.a_969467805.a_1420588258.a2128704133" label="Step2">
									<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a531198060.a1132618956.a_969467805.a_1420588258.a2128704133.a499910548" width="200px" height="150px">
									</UiImage>
								</UiStep>
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a531198060.a1132618956.a_969467805.a_1420588258.a2128704134" label="Step3">
									<UiDate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a531198060.a1132618956.a_969467805.a_1420588258.a2128704134.a1429360466" pattern="DD/MM/YYYY">
									</UiDate>
								</UiStep>
							</UiStepper>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a531198060.a1132618956.a_969467805.a1326272841" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a531198060.a1132618956.a_969467805.a1326272841.a_1380207179" mode="normal" language="Html" value="Stepper&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step1 as Labeled&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step1&quot;&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;hola1&quot;)&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step2 as Labeled&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step2&quot;&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Image(defaultValue =&quot; images/image.jpg&quot;) as Absolute(width = 200px, height = 150px)&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step3 as Labeled&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step3&quot;&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Date(pattern = &quot;DD/MM/YYYY&quot;)&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a531198060.a_47948293" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a531198060.a_47948293.a_916994366" format="h6" mode="normal" value="No facet. Position top, Orientation horizontal">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a531198060.a_47948293.a_1997796874" format="filledNoAirExtraLarge" layout="vertical">
							<UiStepper context={this._context.bind(this)} owner={this._owner.bind(this)} id="a531198060.a_47948293.a_1997796874.a_1232897957" style="Full"    orientation="horizontal" position="top">
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a531198060.a_47948293.a_1997796874.a_1232897957.a_360202748" label="Step1">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a531198060.a_47948293.a_1997796874.a_1232897957.a_360202748.a_1828033395" mode="normal" value="Hello">
									</UiText>
								</UiStep>
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a531198060.a_47948293.a_1997796874.a_1232897957.a_360202747" label="Step2">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a531198060.a_47948293.a_1997796874.a_1232897957.a_360202747.a662194256" mode="normal" value="World">
									</UiText>
								</UiStep>
							</UiStepper>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a531198060.a_47948293.a_1997796874.a_1752860956" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a531198060.a_47948293.a_1997796874.a_1752860956.a1121676106" mode="normal" language="Html" value="Stepper&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;position = Top&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step4 as Labeled&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step1&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;Hello&quot;)&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step5 as Labeled&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step2&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;World&quot;)&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a531198060.a_425767176" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a531198060.a_425767176.a440186873" format="h6" mode="normal" value="No facet. Position left, Orientation vertical">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a531198060.a_425767176.a1610142530" format="filledNoAirExtraLarge" layout="vertical">
							<UiStepper context={this._context.bind(this)} owner={this._owner.bind(this)} id="a531198060.a_425767176.a1610142530.a1536446724" style="Full"    orientation="vertical" position="left">
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a531198060.a_425767176.a1610142530.a1536446724.a_1315720209" label="Step1">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a531198060.a_425767176.a1610142530.a1536446724.a_1315720209.a1905997886" mode="normal" value="Hello">
									</UiText>
								</UiStep>
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a531198060.a_425767176.a1610142530.a1536446724.a_1315720208" label="Step2">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a531198060.a_425767176.a1610142530.a1536446724.a_1315720208.a_1925538292" mode="normal" value="World">
									</UiText>
								</UiStep>
							</UiStepper>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a531198060.a_425767176.a1610142530.a2040672022" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a531198060.a_425767176.a1610142530.a2040672022.a578599781" mode="normal" language="Html" value="Stepper&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;position = Left&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;orientation = Vertical&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step6 as Labeled&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step1&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;Hello&quot;)&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step7 as Labeled&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step2&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;World&quot;)&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a679118020" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a679118020.a785643424" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a679118020.a785643424.a1214020684" format="h6" mode="normal" value="No facet. Position right, Orientation vertical">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a679118020.a785643424.a760335788" format="filledNoAirExtraLarge" layout="vertical">
							<UiStepper context={this._context.bind(this)} owner={this._owner.bind(this)} id="a679118020.a785643424.a760335788.a1982302463" style="Full"    orientation="vertical" position="right">
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a679118020.a785643424.a760335788.a1982302463.a_1503804500" label="Step1">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a679118020.a785643424.a760335788.a1982302463.a_1503804500.a1608230310" mode="normal" value="Hello">
									</UiText>
								</UiStep>
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a679118020.a785643424.a760335788.a1982302463.a_1503804499" label="Step2">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a679118020.a785643424.a760335788.a1982302463.a_1503804499.a_196509335" mode="normal" value="World">
									</UiText>
								</UiStep>
							</UiStepper>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a679118020.a785643424.a760335788.a_271621983" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a679118020.a785643424.a760335788.a_271621983.a1915146429" mode="normal" language="Html" value="Stepper&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;position = Right&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;orientation = Vertical&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step8 as Labeled&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step1&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;Hello&quot;)&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step9 as Labeled&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step2&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;World&quot;)&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a679118020.a_1754048718" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a679118020.a_1754048718.a_315282669" format="h6" mode="normal" value="MaterialIcon facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a679118020.a_1754048718.a_1057183193" format="filledNoAirExtraLarge" layout="vertical">
							<UiStepper context={this._context.bind(this)} owner={this._owner.bind(this)} id="a679118020.a_1754048718.a_1057183193.a375378727" style="Full"    orientation="horizontal" position="bottom">
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a679118020.a_1754048718.a_1057183193.a375378727.a_1471534589" label="Step1" icon="AddCircle">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a679118020.a_1754048718.a_1057183193.a375378727.a_1471534589.a_1549801407" mode="normal" value="Hello">
									</UiText>
								</UiStep>
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a679118020.a_1754048718.a_1057183193.a375378727.a_1471534588" label="Step2" icon="Menu">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a679118020.a_1754048718.a_1057183193.a375378727.a_1471534588.a587468101" mode="normal" value="World">
									</UiText>
								</UiStep>
							</UiStepper>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a679118020.a_1754048718.a_1057183193.a1313657410" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a679118020.a_1754048718.a_1057183193.a1313657410.a173064149" mode="normal" language="Html" value="Stepper&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step10 as Labeled MaterialIcon&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step1&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;icon = &quot;AddCircle&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;Hello&quot;)&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step11 as Labeled MaterialIcon&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step2&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;icon = &quot;Menu&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;World&quot;)&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(StepperExamplesMold));
DisplayFactory.register("StepperExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(StepperExamplesMold)));