import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiMultiple from "alexandria-ui-elements/src/displays/components/Multiple";
import DisplaysMethodParamMold from "ui-elements/gen/displays/templates/MethodParamMold";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import MethodMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import MethodMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class MethodMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new MethodMoldNotifier(this);
		this.requester = new MethodMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="airBottom" layout="vertical" style={{...this.props.style,...display}}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1496800449" format="body2 facetsAbsolute" mode="uppercase" value="">
				</UiText>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a787489738" layout="horizontal startjustified">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a787489738.a_1770764645" format="h6" mode="normal">
					</UiText>
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a787489738.a_864048470" format="h6" mode="normal" value="(">
					</UiText>
					<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a787489738.a_840367722" multiple={{instances:"params",arrangement:"Vertical",noItemsMessage:"",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
					</UiMultiple>
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a787489738.a_2143256869" format="h6" mode="normal" value=")">
					</UiText>
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a787489738.a_634599789" format="h6" mode="normal" value=":  ">
					</UiText>
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a787489738.a_74471270" format="h6 widgetType" mode="lowercase">
					</UiText>
				</UiBlock>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1078061065" format="body2" mode="normal" value="">
				</UiText>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(MethodMold));
DisplayFactory.register("MethodMold", withStyles(styles, { withTheme: true })(withSnackbar(MethodMold)));